/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.facebook.LoggingBehavior;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedPreferencesTokenCachingStrategy
extends TokenCachingStrategy {
    private static final String DEFAULT_CACHE_KEY = "com.facebook.SharedPreferencesTokenCachingStrategy.DEFAULT_KEY";
    private static final String TAG = SharedPreferencesTokenCachingStrategy.class.getSimpleName();
    private static final String JSON_VALUE_TYPE = "valueType";
    private static final String JSON_VALUE = "value";
    private static final String JSON_VALUE_ENUM_TYPE = "enumType";
    private static final String TYPE_BOOLEAN = "bool";
    private static final String TYPE_BOOLEAN_ARRAY = "bool[]";
    private static final String TYPE_BYTE = "byte";
    private static final String TYPE_BYTE_ARRAY = "byte[]";
    private static final String TYPE_SHORT = "short";
    private static final String TYPE_SHORT_ARRAY = "short[]";
    private static final String TYPE_INTEGER = "int";
    private static final String TYPE_INTEGER_ARRAY = "int[]";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_LONG_ARRAY = "long[]";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_FLOAT_ARRAY = "float[]";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_DOUBLE_ARRAY = "double[]";
    private static final String TYPE_CHAR = "char";
    private static final String TYPE_CHAR_ARRAY = "char[]";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_STRING_LIST = "stringList";
    private static final String TYPE_ENUM = "enum";
    private String cacheKey;
    private SharedPreferences cache;

    public SharedPreferencesTokenCachingStrategy(Context context) {
        this(context, null);
    }

    public SharedPreferencesTokenCachingStrategy(Context context, String cacheKey) {
        Validate.notNull(context, "context");
        this.cacheKey = Utility.isNullOrEmpty(cacheKey) ? DEFAULT_CACHE_KEY : cacheKey;
        Context applicationContext = context.getApplicationContext();
        context = applicationContext != null ? applicationContext : context;
        this.cache = context.getSharedPreferences(this.cacheKey, 0);
    }

    @Override
    public Bundle load() {
        Bundle settings = new Bundle();
        Map allCachedEntries = this.cache.getAll();
        for (String key : allCachedEntries.keySet()) {
            try {
                this.deserializeKey(key, settings);
            }
            catch (JSONException e) {
                Logger.log(LoggingBehavior.CACHE, 5, TAG, "Error reading cached value for key: '" + key + "' -- " + (Object)((Object)e));
                return null;
            }
        }
        return settings;
    }

    @Override
    public void save(Bundle bundle) {
        Validate.notNull(bundle, "bundle");
        SharedPreferences.Editor editor = this.cache.edit();
        for (String key : bundle.keySet()) {
            try {
                this.serializeKey(key, bundle, editor);
            }
            catch (JSONException e) {
                Logger.log(LoggingBehavior.CACHE, 5, TAG, "Error processing value for key: '" + key + "' -- " + (Object)((Object)e));
                return;
            }
        }
        boolean successfulCommit = editor.commit();
        if (!successfulCommit) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "SharedPreferences.Editor.commit() was not successful");
        }
    }

    @Override
    public void clear() {
        this.cache.edit().clear().commit();
    }

    private void serializeKey(String key, Bundle bundle, SharedPreferences.Editor editor) throws JSONException {
        Object value = bundle.get(key);
        if (value == null) {
            return;
        }
        String supportedType = null;
        JSONArray jsonArray = null;
        JSONObject json = new JSONObject();
        if (value instanceof Byte) {
            supportedType = TYPE_BYTE;
            json.put(JSON_VALUE, ((Byte)value).intValue());
        } else if (value instanceof Short) {
            supportedType = TYPE_SHORT;
            json.put(JSON_VALUE, ((Short)value).intValue());
        } else if (value instanceof Integer) {
            supportedType = TYPE_INTEGER;
            json.put(JSON_VALUE, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            supportedType = TYPE_LONG;
            json.put(JSON_VALUE, ((Long)value).longValue());
        } else if (value instanceof Float) {
            supportedType = TYPE_FLOAT;
            json.put(JSON_VALUE, ((Float)value).doubleValue());
        } else if (value instanceof Double) {
            supportedType = TYPE_DOUBLE;
            json.put(JSON_VALUE, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            supportedType = TYPE_BOOLEAN;
            json.put(JSON_VALUE, ((Boolean)value).booleanValue());
        } else if (value instanceof Character) {
            supportedType = TYPE_CHAR;
            json.put(JSON_VALUE, (Object)value.toString());
        } else if (value instanceof String) {
            supportedType = TYPE_STRING;
            json.put(JSON_VALUE, (Object)((String)value));
        } else if (value instanceof Enum) {
            supportedType = TYPE_ENUM;
            json.put(JSON_VALUE, (Object)value.toString());
            json.put(JSON_VALUE_ENUM_TYPE, (Object)value.getClass().getName());
        } else {
            jsonArray = new JSONArray();
            if (value instanceof byte[]) {
                supportedType = TYPE_BYTE_ARRAY;
                byte[] byArray = (byte[])value;
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte v = byArray[n2];
                    jsonArray.put((int)v);
                    ++n2;
                }
            } else if (value instanceof short[]) {
                supportedType = TYPE_SHORT_ARRAY;
                short[] sArray = (short[])value;
                int n = sArray.length;
                int n3 = 0;
                while (n3 < n) {
                    short v = sArray[n3];
                    jsonArray.put((int)v);
                    ++n3;
                }
            } else if (value instanceof int[]) {
                supportedType = TYPE_INTEGER_ARRAY;
                int[] nArray = (int[])value;
                int n = nArray.length;
                int n4 = 0;
                while (n4 < n) {
                    int v = nArray[n4];
                    jsonArray.put(v);
                    ++n4;
                }
            } else if (value instanceof long[]) {
                supportedType = TYPE_LONG_ARRAY;
                long[] lArray = (long[])value;
                int n = lArray.length;
                int n5 = 0;
                while (n5 < n) {
                    long v = lArray[n5];
                    jsonArray.put(v);
                    ++n5;
                }
            } else if (value instanceof float[]) {
                supportedType = TYPE_FLOAT_ARRAY;
                float[] fArray = (float[])value;
                int n = fArray.length;
                int n6 = 0;
                while (n6 < n) {
                    float v = fArray[n6];
                    jsonArray.put((double)v);
                    ++n6;
                }
            } else if (value instanceof double[]) {
                supportedType = TYPE_DOUBLE_ARRAY;
                double[] dArray = (double[])value;
                int n = dArray.length;
                int n7 = 0;
                while (n7 < n) {
                    double v = dArray[n7];
                    jsonArray.put(v);
                    ++n7;
                }
            } else if (value instanceof boolean[]) {
                supportedType = TYPE_BOOLEAN_ARRAY;
                boolean[] blArray = (boolean[])value;
                int n = blArray.length;
                int n8 = 0;
                while (n8 < n) {
                    boolean v = blArray[n8];
                    jsonArray.put(v);
                    ++n8;
                }
            } else if (value instanceof char[]) {
                supportedType = TYPE_CHAR_ARRAY;
                char[] cArray = (char[])value;
                int n = cArray.length;
                int n9 = 0;
                while (n9 < n) {
                    char v = cArray[n9];
                    jsonArray.put((Object)String.valueOf(v));
                    ++n9;
                }
            } else if (value instanceof List) {
                supportedType = TYPE_STRING_LIST;
                List stringList = (List)value;
                for (String v : stringList) {
                    jsonArray.put(v == null ? JSONObject.NULL : v);
                }
            } else {
                jsonArray = null;
            }
        }
        if (supportedType != null) {
            json.put(JSON_VALUE_TYPE, (Object)supportedType);
            if (jsonArray != null) {
                json.putOpt(JSON_VALUE, jsonArray);
            }
            String jsonString = json.toString();
            editor.putString(key, jsonString);
        }
    }

    private void deserializeKey(String key, Bundle bundle) throws JSONException {
        String jsonString = this.cache.getString(key, "{}");
        JSONObject json = new JSONObject(jsonString);
        String valueType = json.getString(JSON_VALUE_TYPE);
        if (valueType.equals(TYPE_BOOLEAN)) {
            bundle.putBoolean(key, json.getBoolean(JSON_VALUE));
        } else if (valueType.equals(TYPE_BOOLEAN_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            boolean[] array = new boolean[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = jsonArray.getBoolean(i);
                ++i;
            }
            bundle.putBooleanArray(key, array);
        } else if (valueType.equals(TYPE_BYTE)) {
            bundle.putByte(key, (byte)json.getInt(JSON_VALUE));
        } else if (valueType.equals(TYPE_BYTE_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            byte[] array = new byte[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = (byte)jsonArray.getInt(i);
                ++i;
            }
            bundle.putByteArray(key, array);
        } else if (valueType.equals(TYPE_SHORT)) {
            bundle.putShort(key, (short)json.getInt(JSON_VALUE));
        } else if (valueType.equals(TYPE_SHORT_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            short[] array = new short[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = (short)jsonArray.getInt(i);
                ++i;
            }
            bundle.putShortArray(key, array);
        } else if (valueType.equals(TYPE_INTEGER)) {
            bundle.putInt(key, json.getInt(JSON_VALUE));
        } else if (valueType.equals(TYPE_INTEGER_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            int[] array = new int[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = jsonArray.getInt(i);
                ++i;
            }
            bundle.putIntArray(key, array);
        } else if (valueType.equals(TYPE_LONG)) {
            bundle.putLong(key, json.getLong(JSON_VALUE));
        } else if (valueType.equals(TYPE_LONG_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            long[] array = new long[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = jsonArray.getLong(i);
                ++i;
            }
            bundle.putLongArray(key, array);
        } else if (valueType.equals(TYPE_FLOAT)) {
            bundle.putFloat(key, (float)json.getDouble(JSON_VALUE));
        } else if (valueType.equals(TYPE_FLOAT_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            float[] array = new float[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = (float)jsonArray.getDouble(i);
                ++i;
            }
            bundle.putFloatArray(key, array);
        } else if (valueType.equals(TYPE_DOUBLE)) {
            bundle.putDouble(key, json.getDouble(JSON_VALUE));
        } else if (valueType.equals(TYPE_DOUBLE_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            double[] array = new double[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                array[i] = jsonArray.getDouble(i);
                ++i;
            }
            bundle.putDoubleArray(key, array);
        } else if (valueType.equals(TYPE_CHAR)) {
            String charString = json.getString(JSON_VALUE);
            if (charString != null && charString.length() == 1) {
                bundle.putChar(key, charString.charAt(0));
            }
        } else if (valueType.equals(TYPE_CHAR_ARRAY)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            char[] array = new char[jsonArray.length()];
            int i = 0;
            while (i < array.length) {
                String charString = jsonArray.getString(i);
                if (charString != null && charString.length() == 1) {
                    array[i] = charString.charAt(0);
                }
                ++i;
            }
            bundle.putCharArray(key, array);
        } else if (valueType.equals(TYPE_STRING)) {
            bundle.putString(key, json.getString(JSON_VALUE));
        } else if (valueType.equals(TYPE_STRING_LIST)) {
            JSONArray jsonArray = json.getJSONArray(JSON_VALUE);
            int numStrings = jsonArray.length();
            ArrayList<String> stringList = new ArrayList<String>(numStrings);
            int i = 0;
            while (i < numStrings) {
                Object jsonStringValue = jsonArray.get(i);
                stringList.add(i, jsonStringValue == JSONObject.NULL ? null : (String)jsonStringValue);
                ++i;
            }
            bundle.putStringArrayList(key, stringList);
        } else if (valueType.equals(TYPE_ENUM)) {
            try {
                String enumType = json.getString(JSON_VALUE_ENUM_TYPE);
                Class<?> enumClass = Class.forName(enumType);
                Object enumValue = Enum.valueOf(enumClass, json.getString(JSON_VALUE));
                bundle.putSerializable(key, enumValue);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

