/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.database.CursorIndexOutOfBoundsException;
import com.facebook.model.GraphObject;
import com.facebook.widget.GraphObjectCursor;
import java.util.ArrayList;
import java.util.Collection;

class SimpleGraphObjectCursor<T extends GraphObject>
implements GraphObjectCursor<T> {
    private int pos = -1;
    private boolean closed = false;
    private ArrayList<T> graphObjects = new ArrayList();
    private boolean moreObjectsAvailable = false;
    private boolean fromCache = false;

    SimpleGraphObjectCursor() {
    }

    SimpleGraphObjectCursor(SimpleGraphObjectCursor<T> other) {
        this.pos = other.pos;
        this.closed = other.closed;
        this.graphObjects = new ArrayList();
        this.graphObjects.addAll(other.graphObjects);
        this.fromCache = other.fromCache;
    }

    public void addGraphObjects(Collection<T> graphObjects, boolean fromCache) {
        this.graphObjects.addAll(graphObjects);
        this.fromCache |= fromCache;
    }

    @Override
    public boolean isFromCache() {
        return this.fromCache;
    }

    public void setFromCache(boolean fromCache) {
        this.fromCache = fromCache;
    }

    @Override
    public boolean areMoreObjectsAvailable() {
        return this.moreObjectsAvailable;
    }

    public void setMoreObjectsAvailable(boolean moreObjectsAvailable) {
        this.moreObjectsAvailable = moreObjectsAvailable;
    }

    @Override
    public int getCount() {
        return this.graphObjects.size();
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public boolean move(int offset) {
        return this.moveToPosition(this.pos + offset);
    }

    @Override
    public boolean moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.pos = count;
            return false;
        }
        if (position < 0) {
            this.pos = -1;
            return false;
        }
        this.pos = position;
        return true;
    }

    @Override
    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    @Override
    public boolean moveToNext() {
        return this.moveToPosition(this.pos + 1);
    }

    @Override
    public boolean moveToPrevious() {
        return this.moveToPosition(this.pos - 1);
    }

    @Override
    public boolean isFirst() {
        return this.pos == 0 && this.getCount() != 0;
    }

    @Override
    public boolean isLast() {
        int count = this.getCount();
        return this.pos == count - 1 && count != 0;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.getCount() == 0 || this.pos == -1;
    }

    @Override
    public boolean isAfterLast() {
        int count = this.getCount();
        return count == 0 || this.pos == count;
    }

    @Override
    public T getGraphObject() {
        if (this.pos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first object.");
        }
        if (this.pos >= this.graphObjects.size()) {
            throw new CursorIndexOutOfBoundsException("After last object.");
        }
        return (T)((GraphObject)this.graphObjects.get(this.pos));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

