/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import com.facebook.ads.internal.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdSettings {
    public static final String TAG = AdSettings.class.getSimpleName();
    private static final String PREFS_NAME = "FBAdPrefs";
    private static final String DEVICE_ID_HASH_PREFS_KEY = "deviceIdHash";
    private static final Collection<String> testDevices;
    private static final Collection<String> emulatorProducts;
    private static String urlPrefix;
    private static boolean childDirected;
    private static String deviceIdHash;
    static volatile boolean testDeviceNoticeDisplayed;

    public static void addTestDevice(String deviceIdHash) {
        testDevices.add(deviceIdHash);
    }

    public static void addTestDevices(Collection<String> deviceIdHashes) {
        testDevices.addAll(deviceIdHashes);
    }

    public static void clearTestDevices() {
        testDevices.clear();
    }

    public static boolean isTestMode(Context context) {
        SharedPreferences adPrefs;
        if (emulatorProducts.contains(Build.PRODUCT)) {
            return true;
        }
        if (deviceIdHash == null && StringUtils.isNullOrEmpty(deviceIdHash = (adPrefs = context.getSharedPreferences(PREFS_NAME, 0)).getString(DEVICE_ID_HASH_PREFS_KEY, null))) {
            deviceIdHash = StringUtils.md5(UUID.randomUUID().toString());
            adPrefs.edit().putString(DEVICE_ID_HASH_PREFS_KEY, deviceIdHash).commit();
        }
        if (testDevices.contains(deviceIdHash)) {
            return true;
        }
        AdSettings.printTestDeviceNotice(deviceIdHash);
        return false;
    }

    private static void printTestDeviceNotice(String deviceIdHash) {
        if (testDeviceNoticeDisplayed) {
            return;
        }
        testDeviceNoticeDisplayed = true;
        Log.d((String)TAG, (String)("Test mode device hash: " + deviceIdHash));
        Log.d((String)TAG, (String)("When testing your app with Facebook's ad units you must specify the device hashed ID to ensure the delivery of test ads, add the following code before loading an ad: AdSettings.addTestDevice(\"" + deviceIdHash + "\");"));
    }

    public static void setUrlPrefix(String urlPrefix) {
        AdSettings.urlPrefix = urlPrefix;
    }

    public static String getUrlPrefix() {
        return urlPrefix;
    }

    public static void setIsChildDirected(boolean childDirected) {
        AdSettings.childDirected = childDirected;
    }

    public static boolean isChildDirected() {
        return childDirected;
    }

    static {
        urlPrefix = null;
        childDirected = false;
        deviceIdHash = null;
        testDevices = new HashSet<String>();
        emulatorProducts = new HashSet<String>();
        emulatorProducts.add("sdk");
        emulatorProducts.add("google_sdk");
        emulatorProducts.add("vbox86p");
        emulatorProducts.add("vbox86tp");
        testDeviceNoticeDisplayed = false;
    }
}

