/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.internal.AdDataModel;
import com.facebook.ads.internal.AdHandler;
import com.facebook.ads.internal.AdRequest;
import com.facebook.ads.internal.AdRequestController;
import com.facebook.ads.internal.AdResponse;
import com.facebook.ads.internal.AdType;
import com.facebook.ads.internal.AdWebViewInterface;
import com.facebook.ads.internal.AdWebViewUtils;
import com.facebook.ads.internal.HtmlAdDataModel;
import com.facebook.ads.internal.HtmlAdHandler;
import com.facebook.ads.internal.action.AdAction;
import com.facebook.ads.internal.action.AdActionFactory;
import java.util.Map;
import java.util.UUID;

public class AdView
extends RelativeLayout
implements Ad {
    private static final String TAG = AdView.class.getSimpleName();
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final int DEFAULT_ALPHA = 255;
    private static final int MIN_ALPHA = 229;
    private int currentAlpha = 255;
    private final String placementId;
    private final AdSize adSize;
    private AdListener adListener = null;
    private WebView adWebView;
    private AdRequestController adRequestController;
    private HtmlAdHandler adHandler;
    private final DisplayMetrics metrics;
    private final ScreenStateReceiver screenStateReceiver;
    private int viewabilityThreshold;

    public AdView(Context context, String placementId, AdSize adSize) {
        super(context);
        if (adSize == null || adSize == AdSize.INTERSTITIAL) {
            throw new IllegalArgumentException("adSize");
        }
        this.placementId = placementId;
        this.adSize = adSize;
        this.metrics = context.getResources().getDisplayMetrics();
        this.screenStateReceiver = new ScreenStateReceiver();
        this.initializeView(context);
        this.adHandler = new HtmlAdHandler(this.adWebView, new AdHandler.ImpressionHelper(){

            public boolean shouldSendImpression() {
                return AdView.this.isAdViewVisible();
            }

            public void afterImpressionSent() {
                if (AdView.this.adRequestController != null) {
                    AdView.this.adRequestController.scheduleRefresh("on imp sent");
                }
            }
        }, 1000L, context);
        this.registerScreenStateReceiver();
    }

    private void initializeView(Context context) {
        this.resizeAdView();
        this.adWebView = new WebView(context);
        this.adWebView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.adWebView.setVisibility(8);
        AdWebViewUtils.config(this.adWebView, new AdWebViewClient(), new AdWebViewInterface());
        this.addView((View)this.adWebView);
        this.adRequestController = new AdRequestController(this.getContext(), this.placementId, this.adSize, true, AdType.HTML, this.createAdRequestCallback());
    }

    private AdRequest.Callback createAdRequestCallback() {
        return new AdRequest.Callback(){

            public void onError(AdError error) {
                AdView.this.adHandler.cancelImpressionRetry();
                if (AdView.this.adListener != null) {
                    AdView.this.adListener.onError(AdView.this, error);
                }
            }

            public void onCompleted(AdResponse adResponse) {
                AdView.this.adHandler.cancelImpressionRetry();
                AdDataModel dataModel = adResponse.getDataModel();
                if (dataModel != null && dataModel instanceof HtmlAdDataModel) {
                    AdView.this.adHandler.setAdDataModel((HtmlAdDataModel)dataModel);
                    AdView.this.updateView((HtmlAdDataModel)dataModel);
                    if (AdView.this.adListener != null) {
                        AdView.this.adListener.onAdLoaded(AdView.this);
                    }
                    AdView.this.viewabilityThreshold = adResponse.getViewabilityThreshold();
                } else if (dataModel == null) {
                    if (AdView.this.adListener != null) {
                        AdView.this.adListener.onError(AdView.this, adResponse.getError() != null ? adResponse.getError() : AdError.INTERNAL_ERROR);
                    }
                    if (AdView.this.adRequestController != null) {
                        AdView.this.adRequestController.scheduleRefresh("on no fill");
                    }
                } else {
                    if (AdView.this.adListener != null) {
                        AdView.this.adListener.onError(AdView.this, AdError.INTERNAL_ERROR);
                    }
                    if (AdView.this.adRequestController != null) {
                        AdView.this.adRequestController.scheduleRefresh("on internal error");
                    }
                }
            }
        };
    }

    public void setAdListener(AdListener adListener) {
        this.adListener = adListener;
    }

    public void loadAd() {
        this.ensureAdRequestController();
        this.adRequestController.loadAd();
    }

    private void ensureAdRequestController() {
        if (this.adRequestController == null) {
            throw new RuntimeException("No request controller available, has the AdView been destroyed?");
        }
    }

    private void updateView(HtmlAdDataModel dataModel) {
        this.adWebView.loadUrl("about:blank");
        this.adWebView.clearCache(true);
        this.adWebView.setVisibility(8);
        this.adWebView.loadDataWithBaseURL("https://www.facebook.com/", dataModel.getMarkup(), DEFAULT_MIME_TYPE, DEFAULT_ENCODING, null);
        this.adWebView.setVisibility(0);
    }

    public void destroy() {
        if (this.adRequestController != null) {
            this.adRequestController.destroy();
            this.adRequestController = null;
        }
        this.adHandler.cancelImpressionRetry();
        this.unregisterScreenStateReceiver();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.adRequestController != null) {
            this.adRequestController.onWindowVisibilityChanged(visibility);
        }
        if (visibility == 0) {
            this.adHandler.scheduleImpressionRetry();
        } else {
            this.adHandler.cancelImpressionRetry();
        }
    }

    protected boolean onSetAlpha(int alpha) {
        this.currentAlpha = alpha;
        return super.onSetAlpha(alpha);
    }

    private boolean isAdViewVisible() {
        if (this.getVisibility() != 0) {
            return false;
        }
        if (this.getParent() == null) {
            return false;
        }
        if (this.currentAlpha < 229) {
            return false;
        }
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        if (location[0] < 0 || this.metrics.widthPixels - location[0] < (int)Math.ceil((float)this.adSize.getWidth() * this.metrics.density)) {
            return false;
        }
        int adHeight = (int)Math.ceil((float)this.adSize.getHeight() * this.metrics.density);
        int verticalInvisibleThreshold = (int)((double)adHeight * (100.0 - (double)this.viewabilityThreshold) / 100.0);
        if (location[1] < 0 && Math.abs(location[1]) > verticalInvisibleThreshold) {
            return false;
        }
        int bottomDistance = location[1] + adHeight - this.metrics.heightPixels;
        return bottomDistance <= verticalInvisibleThreshold;
    }

    private void registerScreenStateReceiver() {
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.getContext().registerReceiver((BroadcastReceiver)this.screenStateReceiver, filter);
    }

    private void unregisterScreenStateReceiver() {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.screenStateReceiver);
    }

    private void resizeAdView() {
        int screenWidth = (int)((float)this.metrics.widthPixels / this.metrics.density);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(screenWidth >= this.adSize.getWidth() ? this.metrics.widthPixels : (int)Math.ceil((float)this.adSize.getWidth() * this.metrics.density), (int)Math.ceil((float)this.adSize.getHeight() * this.metrics.density));
        layoutParams.addRule(14);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resizeAdView();
    }

    private class ScreenStateReceiver
    extends BroadcastReceiver {
        private ScreenStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(action)) {
                AdView.this.adHandler.cancelImpressionRetry();
            } else {
                AdView.this.adHandler.scheduleImpressionRetry();
            }
        }
    }

    private class AdWebViewClient
    extends WebViewClient {
        private AdWebViewClient() {
        }

        public void onLoadResource(WebView view, String url) {
            AdView.this.adHandler.activateAd();
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (AdView.this.adListener != null) {
                AdView.this.adListener.onAdClicked(AdView.this);
            }
            Uri uri = Uri.parse((String)url);
            AdAction adAction = AdActionFactory.getAdAction(AdView.this.getContext(), uri);
            Map<String, String> map = ((HtmlAdDataModel)AdView.this.adHandler.getAdDataModel()).getDataModelMap();
            map.put("adInterstitialUniqueId", UUID.randomUUID().toString());
            if (adAction != null) {
                try {
                    adAction.execute(map);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"Error executing action", (Throwable)ex);
                }
            }
            return true;
        }
    }
}

