/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Environment;
import android.os.StatFs;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAnalogData {
    private static SensorManager sensorManager = null;
    private static Sensor accelerometer = null;
    private static Sensor gyroscope = null;
    private static volatile float[] accelerometerValues;
    private static volatile float[] gyroscopeValues;
    private static Map<String, Object> analogInfo;
    private static String[] sensorDimensions;

    public static synchronized void startUpdate(Context context) {
        AdAnalogData.putMemoryInfo(context);
        AdAnalogData.putDiskInfo(context);
        AdAnalogData.putBatteryData(context);
        if (sensorManager == null && (sensorManager = (SensorManager)context.getSystemService("sensor")) == null) {
            return;
        }
        if (accelerometer == null) {
            accelerometer = sensorManager.getDefaultSensor(1);
        }
        if (gyroscope == null) {
            gyroscope = sensorManager.getDefaultSensor(4);
        }
        if (accelerometer != null) {
            sensorManager.registerListener((SensorEventListener)new AdSensorEventListener(), accelerometer, 3);
        }
        if (gyroscope != null) {
            sensorManager.registerListener((SensorEventListener)new AdSensorEventListener(), gyroscope, 3);
        }
    }

    public static synchronized void stopUpdate(AdSensorEventListener sensorEventListener) {
        if (sensorManager == null) {
            return;
        }
        sensorManager.unregisterListener((SensorEventListener)sensorEventListener);
    }

    public static Map<String, Object> getAnalogInfo() {
        HashMap<String, Object> currentAnalogInfo = new HashMap<String, Object>();
        currentAnalogInfo.putAll(analogInfo);
        AdAnalogData.putSensorData(currentAnalogInfo);
        return currentAnalogInfo;
    }

    private static void putMemoryInfo(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(mi);
        analogInfo.put("available_memory", String.valueOf(mi.availMem));
    }

    private static void putDiskInfo(Context context) {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        analogInfo.put("free_space", availableBlocks * blockSize);
    }

    private static void putBatteryData(Context context) {
        Intent batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (batteryIntent == null) {
            return;
        }
        int level = batteryIntent.getIntExtra("level", -1);
        int scale = batteryIntent.getIntExtra("scale", -1);
        int status = batteryIntent.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        float batteryLevel = 0.0f;
        if (scale > 0) {
            batteryLevel = (float)level / (float)scale * 100.0f;
        }
        analogInfo.put("battery", Float.valueOf(batteryLevel));
        analogInfo.put("charging", isCharging ? 1 : 0);
    }

    private static void putSensorData(Map<String, Object> analogInfo) {
        int i;
        int length;
        float[] currentAccelerometerValues = accelerometerValues;
        float[] currentGyroscopeValues = gyroscopeValues;
        if (currentAccelerometerValues != null) {
            length = Math.min(sensorDimensions.length, currentAccelerometerValues.length);
            for (i = 0; i < length; ++i) {
                analogInfo.put("accelerometer_" + sensorDimensions[i], Float.valueOf(currentAccelerometerValues[i]));
            }
        }
        if (currentGyroscopeValues != null) {
            length = Math.min(sensorDimensions.length, currentGyroscopeValues.length);
            for (i = 0; i < length; ++i) {
                analogInfo.put("rotation_" + sensorDimensions[i], Float.valueOf(currentGyroscopeValues[i]));
            }
        }
    }

    static /* synthetic */ float[] access$202(float[] x0) {
        accelerometerValues = x0;
        return x0;
    }

    static /* synthetic */ float[] access$402(float[] x0) {
        gyroscopeValues = x0;
        return x0;
    }

    static {
        analogInfo = new ConcurrentHashMap<String, Object>();
        sensorDimensions = new String[]{"x", "y", "z"};
    }

    private static class AdSensorEventListener
    implements SensorEventListener {
        private AdSensorEventListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor == accelerometer) {
                AdAnalogData.access$202(event.values);
            } else if (event.sensor == gyroscope) {
                AdAnalogData.access$402(event.values);
            }
            AdAnalogData.stopUpdate(this);
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

