/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import android.os.Handler;
import com.facebook.ads.internal.AdDataModel;
import com.facebook.ads.internal.AdUtilities;

public abstract class AdHandler {
    protected final ImpressionHelper impressionHelper;
    private final long sendImpressionDelay;
    private final Handler handler;
    private final Runnable sendImpressionRunnable = new Runnable(){

        public void run() {
            AdHandler.this.impressionRetryScheduled = false;
            AdHandler.this.trySendImpression();
        }
    };
    protected AdDataModel adDataModel;
    private Context context;
    private volatile boolean impressionSent;
    private volatile boolean impressionRetryScheduled;

    public AdHandler(ImpressionHelper impressionHelper, long sendImpressionDelay, Context context) {
        this.context = context;
        this.impressionHelper = impressionHelper;
        this.sendImpressionDelay = sendImpressionDelay;
        this.handler = new Handler();
    }

    public void setAdDataModel(AdDataModel adDataModel) {
        this.adDataModel = adDataModel;
        this.impressionSent = false;
        this.impressionRetryScheduled = false;
    }

    public AdDataModel getAdDataModel() {
        return this.adDataModel;
    }

    public synchronized void scheduleImpressionRetry() {
        if (this.impressionSent || this.impressionRetryScheduled || this.adDataModel == null) {
            return;
        }
        this.handler.postDelayed(this.sendImpressionRunnable, this.sendImpressionDelay);
        this.impressionRetryScheduled = true;
    }

    public synchronized void cancelImpressionRetry() {
        if (this.impressionRetryScheduled) {
            this.handler.removeCallbacks(this.sendImpressionRunnable);
            this.impressionRetryScheduled = false;
        }
    }

    public synchronized void trySendImpression() {
        if (this.adDataModel == null || this.impressionSent) {
            return;
        }
        if (this.impressionHelper != null && !this.impressionHelper.shouldSendImpression()) {
            this.scheduleImpressionRetry();
            return;
        }
        this.sendImpression();
        this.impressionSent = true;
        AdUtilities.displayDebugMessage(this.context, "Impression logged");
    }

    protected abstract void sendImpression();

    public static interface ImpressionHelper {
        public boolean shouldSendImpression();

        public void afterImpressionSent();
    }
}

