/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.facebook.ads.NativeAd;
import com.facebook.ads.internal.AdDataModel;
import com.facebook.ads.internal.AdInvalidationBehavior;
import com.facebook.ads.internal.AdInvalidationUtils;
import com.facebook.ads.internal.AdUtilities;
import com.facebook.ads.internal.OpenUrlTask;
import com.facebook.ads.internal.action.AdAction;
import com.facebook.ads.internal.action.AdActionFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeAdDataModel
implements AdDataModel {
    private static final String TAG = NativeAdDataModel.class.getSimpleName();
    private final Uri adCommand;
    private final String title;
    private final String body;
    private final String callToAction;
    private final String socialContext;
    private final NativeAd.Image icon;
    private final NativeAd.Image image;
    private final NativeAd.Rating starRating;
    private final String impressionReportUrl;
    private final String clickReportUrl;
    private final AdInvalidationBehavior invalidationBehavior;
    private final Collection<String> detectionStrings;
    private boolean impressionLogged;
    private boolean clickLogged;

    private NativeAdDataModel(Uri adCommand, String title, String body, String callToAction, String socialContext, NativeAd.Image icon, NativeAd.Image image, NativeAd.Rating starRating, String impressionReportUrl, String clickReportUrl, AdInvalidationBehavior invalidationBehavior, Collection<String> detectionStrings) {
        this.adCommand = adCommand;
        this.title = title;
        this.body = body;
        this.callToAction = callToAction;
        this.socialContext = socialContext;
        this.icon = icon;
        this.image = image;
        this.starRating = starRating;
        this.impressionReportUrl = impressionReportUrl;
        this.clickReportUrl = clickReportUrl;
        this.invalidationBehavior = invalidationBehavior;
        this.detectionStrings = detectionStrings;
    }

    @Override
    public AdInvalidationBehavior getInvalidationBehavior() {
        return this.invalidationBehavior;
    }

    @Override
    public Collection<String> getDetectionStrings() {
        return this.detectionStrings;
    }

    public NativeAd.Image getIcon() {
        return this.icon;
    }

    public NativeAd.Image getImage() {
        return this.image;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getCallToAction() {
        return this.callToAction;
    }

    public String getSocialContext() {
        return this.socialContext;
    }

    public NativeAd.Rating getStarRating() {
        return this.starRating;
    }

    public void logImpression() {
        if (!this.impressionLogged) {
            new OpenUrlTask().execute(new String[]{this.impressionReportUrl});
            this.impressionLogged = true;
        }
    }

    public void handleClick(Context context, Map<String, Object> touchData) {
        AdAction adAction;
        if (!this.clickLogged) {
            HashMap<String, String> extraData = new HashMap<String, String>();
            extraData.put("touch", AdUtilities.jsonEncode(touchData));
            new OpenUrlTask(extraData).execute(new String[]{this.clickReportUrl});
            this.clickLogged = true;
            AdUtilities.displayDebugMessage(context, "Click logged");
        }
        if ((adAction = AdActionFactory.getAdAction(context, this.adCommand)) != null) {
            try {
                adAction.execute(null);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Error executing action", (Throwable)ex);
            }
        }
    }

    public boolean isValid() {
        return this.title != null && this.title.length() > 0 && this.callToAction != null && this.callToAction.length() > 0 && this.icon != null && this.image != null;
    }

    public static NativeAdDataModel fromJSONObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String fbadCommand = jsonObject.optString("fbad_command");
        Uri adCommand = Uri.parse((String)fbadCommand);
        String title = jsonObject.optString("title");
        String body = jsonObject.optString("body");
        String callToAction = jsonObject.optString("call_to_action");
        String socialContext = jsonObject.optString("social_context");
        NativeAd.Image icon = NativeAd.Image.fromJSONObject(jsonObject.optJSONObject("icon"));
        NativeAd.Image image = NativeAd.Image.fromJSONObject(jsonObject.optJSONObject("image"));
        NativeAd.Rating starRating = NativeAd.Rating.fromJSONObject(jsonObject.optJSONObject("star_rating"));
        String impressionReportUrl = jsonObject.optString("impression_report_url");
        String clickReportUrl = jsonObject.optString("click_report_url");
        AdInvalidationBehavior invalidationBehavior = AdInvalidationBehavior.fromString(jsonObject.optString("invalidation_behavior"));
        JSONArray detectionStringsArray = null;
        try {
            detectionStringsArray = new JSONArray(jsonObject.optString("detection_strings"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Collection<String> detectionStrings = AdInvalidationUtils.parseDetectionStrings(detectionStringsArray);
        return new NativeAdDataModel(adCommand, title, body, callToAction, socialContext, icon, image, starRating, impressionReportUrl, clickReportUrl, invalidationBehavior, detectionStrings);
    }
}

