/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.os.AsyncTask;
import android.util.Log;
import com.facebook.ads.internal.AdAnalogData;
import com.facebook.ads.internal.AdClientEvent;
import com.facebook.ads.internal.AdClientEventManager;
import com.facebook.ads.internal.AdUtilities;
import com.facebook.ads.internal.StringUtils;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenUrlTask
extends AsyncTask<String, Void, Void> {
    private static final String TAG = OpenUrlTask.class.getSimpleName();
    private static final String INVALID_ADDRESS = "#";
    private Map<String, String> extraData;

    public OpenUrlTask() {
        this.extraData = null;
    }

    public OpenUrlTask(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    protected Void doInBackground(String ... urls) {
        String url = urls[0];
        if (StringUtils.isNullOrEmpty(url) || url.equals(INVALID_ADDRESS)) {
            return null;
        }
        url = this.addAnalogInfo(url);
        if (this.extraData != null) {
            for (String key : this.extraData.keySet()) {
                url = this.addData(url, key, this.extraData.get(key));
            }
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(url);
        try {
            client.execute((HttpUriRequest)get);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Error opening url: " + url), (Throwable)ex);
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
        }
        return null;
    }

    private String addAnalogInfo(String url) {
        try {
            Map<String, Object> analogData = AdAnalogData.getAnalogInfo();
            String analogDataQuery = AdUtilities.jsonEncode(analogData);
            return this.addData(url, "analog", analogDataQuery);
        }
        catch (Exception ex) {
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
            return url;
        }
    }

    private String addData(String url, String key, String data) {
        if (StringUtils.isNullOrEmpty(url) || StringUtils.isNullOrEmpty(key) || StringUtils.isNullOrEmpty(data)) {
            return url;
        }
        String prepend = url.contains("?") ? "&" : "?";
        return url + prepend + key + "=" + URLEncoder.encode(data);
    }
}

