/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.InputDevice;
import com.nibiru.lib.controller.a;

public abstract class BaseEvent
extends a {
    public static final int NIBIRU_EVENT_META_DATA = 32768;
    public static final int NIBIRU_EVENT_DEVICE_ID = 65535;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_ONCE = 255;
    protected int playerOrder;
    protected int deviceId;
    protected long eventTime;
    protected int eventType;

    public BaseEvent(Bundle bundle) {
        super(bundle);
        if (bundle != null) {
            this.playerOrder = bundle.getInt("playerOrder");
            this.deviceId = bundle.getInt("deviceId");
            this.eventTime = bundle.getLong("eventTime");
            this.eventType = bundle.getInt("event_type");
        }
    }

    public BaseEvent(BaseEvent baseEvent) {
        this.playerOrder = baseEvent.playerOrder;
        this.deviceId = baseEvent.deviceId;
        this.eventTime = baseEvent.eventTime;
        this.eventType = baseEvent.eventType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int n2) {
        this.eventType = n2;
        this.setInt("event_type", n2);
    }

    public BaseEvent() {
        this.setEventTime(SystemClock.uptimeMillis());
    }

    public BaseEvent(int n2, int n3) {
        this();
        this.setPlayerOrder(n2);
        this.setDeviceId(n3);
    }

    public BaseEvent(int n2) {
        this();
        this.setPlayerOrder(n2);
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n2) {
        this.playerOrder = n2;
        this.setInt("playerOrder", n2);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int n2) {
        this.deviceId = n2;
        this.setInt("deviceId", n2);
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long l2) {
        this.eventTime = l2;
        this.setLong("eventTime", l2);
    }

    public static int getDeviceId(String string) {
        if (string == null) {
            return -1;
        }
        int[] nArray = InputDevice.getDeviceIds();
        if (nArray != null && nArray.length > 0) {
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                InputDevice inputDevice = InputDevice.getDevice((int)n4);
                if (inputDevice != null && TextUtils.equals((CharSequence)string, (CharSequence)inputDevice.getName())) {
                    return n4;
                }
                ++n3;
            }
        }
        return -1;
    }

    public abstract String getUnityMessage();
}

