/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerDevice;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.OnKeyListener;
import com.nibiru.lib.controller.OnSimpleStickListener;
import com.nibiru.lib.controller.OnStateListener;

public class ControllerActivityInternal
extends Activity
implements ControllerService.OnControllerSeviceListener,
OnKeyListener,
OnSimpleStickListener,
OnStateListener {
    protected ControllerService mControllerService;

    protected void onCreate(Bundle object) {
        super.onCreate(object);
        object = this;
        this.mControllerService = Controller.getControllerService((Context)object);
        object.mControllerService.setKeyListener((OnKeyListener)object);
        object.mControllerService.setSimpleStickListener((OnSimpleStickListener)object);
        object.mControllerService.setStateListener((OnStateListener)object);
        object.mControllerService.setControllerServiceListener((ControllerService.OnControllerSeviceListener)object);
        object.mControllerService.setHandler(new Handler());
        if (object.mControllerService != null && !object.mControllerService.isServiceEnable()) {
            try {
                object.mControllerService.register();
                return;
            }
            catch (ControllerServiceException controllerServiceException) {
                object = controllerServiceException;
                controllerServiceException.printStackTrace();
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
            this.mControllerService = null;
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.onPause();
            this.setScreenOnMode(false);
        }
    }

    public void startCursorMode(int n2) {
        if (this.mControllerService != null && this.mControllerService.getCursorService() != null) {
            this.mControllerService.getCursorService().createCursor(n2);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mControllerService != null) {
            this.mControllerService.onResume();
            this.mControllerService.handleFullScreenMode();
            if (this.mControllerService.hasDeviceConnected()) {
                this.setScreenOnMode(true);
            }
        }
    }

    public void showGameGuide(boolean bl) {
        if (this.mControllerService == null) {
            return;
        }
        this.mControllerService.showGameGuide(bl);
    }

    public boolean hasDeviceConnected() throws ControllerServiceException {
        if (this.mControllerService == null) {
            throw new ControllerServiceException("Controller Service is not connected to driver, please install your driver first and wait for connection build");
        }
        return this.mControllerService.hasDeviceConnected();
    }

    public void setArrowResId(int n2) {
        if (this.mControllerService != null && this.mControllerService.getCursorService() != null) {
            this.mControllerService.getCursorService().setCursorResource(n2);
        }
    }

    protected void setScreenOnMode(boolean bl) {
        if (bl) {
            this.getWindow().clearFlags(128);
            this.getWindow().setFlags(128, 128);
            return;
        }
        this.getWindow().clearFlags(128);
    }

    @Override
    public void onControllerStateChanged(int n2, int n3, ControllerDevice controllerDevice) {
    }

    @Override
    public void onBluetoothStateChanged(int n2) {
    }

    @Override
    public void onControllerKeyDown(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
    }

    @Override
    public void onControllerKeyUp(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
    }

    public boolean isControllerServiceEnable() {
        return this.mControllerService != null && this.mControllerService.isServiceEnable();
    }

    public ControllerService getControllerService() {
        return this.mControllerService;
    }

    @Override
    public void onControllerServiceReady(boolean bl) {
    }

    @Override
    public void onLeftStickChanged(int n2, float f2, float f3) {
    }

    @Override
    public void onRightStickChanged(int n2, float f2, float f3) {
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)keyEvent)) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)motionEvent)) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    protected void onStart() {
        super.onStart();
        if (this.mControllerService != null) {
            this.mControllerService.onStart();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mControllerService != null) {
            this.mControllerService.onStop();
        }
    }
}

