/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import com.nibiru.lib.BTDevice;
import java.util.Arrays;

public class ControllerDevice
implements Parcelable {
    private int playerOrder;
    private int state;
    private int c;
    private boolean isExternal;
    private int deviceId;
    private int features;
    private String S = "0:0:0:0:0";
    private String deviceName = "NO DEVICE";
    private int deviceType;
    private boolean isSupportAcc = false;
    private boolean isSupportGyro = false;
    private int[] accArray;
    private int[] T;
    public static final int STATE_CONNING = 0;
    public static final int STATE_CONN = 1;
    public static final int STATE_DISCONNING = 2;
    public static final int STATE_DISCONN = 3;
    public static final int POS_LEFT = 0;
    public static final int POS_RIGHT = 1;
    public static final int DUR_INFINITE = 0;
    public static final int DEVICE_TYPE_CONTROLLER_24G = 0;
    public static final int DEVICE_TYPE_CONTROLLER_BT = 1;
    public static final int DEVICE_TYPE_BRACELET = 2;
    public static final int DEVICE_TYPE_GUN = 3;
    public static final int DEVICE_TYPE_DANCE = 4;
    public static final int DEVICE_TYPE_GESTURE_GLASS = 5;
    public static final int DEVICE_TYPE_CAMERA = 6;
    public static final int DEVICE_TYPE_STICK = 7;
    public static final int DEVICE_TYPE_WHEEL = 8;
    public static final int DEVICE_TYPE_RING = 9;
    public static final int DEVICE_TYPE_WATCH = 10;
    public static final int DEVICE_TYPE_BRAIN = 11;
    public static final int DEVICE_TYPE_SHOE = 12;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new ControllerDevice(parcel);
        }
    };

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n2) {
        this.playerOrder = n2;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n2) {
        this.state = n2;
    }

    public boolean isConnected() {
        return this.state == 1;
    }

    public int getDeviceType() {
        return this.c;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int n2) {
        this.deviceId = n2;
    }

    public String getAddress() {
        return this.S;
    }

    public void setAddress(String string) {
        this.S = string;
    }

    public int getFeatures() {
        return this.features;
    }

    public void setFeatures(int n2) {
        this.features = n2;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public boolean isSupportAcc() {
        return this.isSupportAcc;
    }

    public void setSupportAcc(boolean bl) {
        this.isSupportAcc = bl;
    }

    public boolean isSupportGyro() {
        return this.isSupportGyro;
    }

    public void setSupportGyro(boolean bl) {
        this.isSupportGyro = bl;
    }

    public int[] getAccMaxArray() {
        if (this.accArray != null) {
            int[] nArray = Arrays.copyOf(this.accArray, this.accArray.length);
            return nArray;
        }
        return new int[3];
    }

    public int[] getGyroMaxArray() {
        if (this.T != null) {
            int[] nArray = Arrays.copyOf(this.T, this.T.length);
            return nArray;
        }
        return new int[3];
    }

    public int getAccXMax() {
        if (this.accArray == null) {
            return 0;
        }
        return this.accArray[0];
    }

    public int getAccYMax() {
        if (this.accArray == null) {
            return 0;
        }
        return this.accArray[1];
    }

    public int getAccZMax() {
        if (this.accArray == null) {
            return 0;
        }
        return this.accArray[2];
    }

    public int getGyroXMax() {
        if (this.T == null) {
            return 0;
        }
        return this.T[0];
    }

    public int getGyroYMax() {
        if (this.T == null) {
            return 0;
        }
        return this.T[1];
    }

    public int getGyroZMax() {
        if (this.T == null) {
            return 0;
        }
        return this.T[2];
    }

    public void setAccMaxArray(int[] nArray) {
        if (nArray != null) {
            this.accArray = Arrays.copyOf(nArray, nArray.length);
        }
    }

    public void setGyroMaxArray(int[] nArray) {
        if (nArray != null) {
            this.T = Arrays.copyOf(nArray, nArray.length);
        }
    }

    public ControllerDevice(BTDevice bTDevice) {
        if (bTDevice == null) {
            return;
        }
        this.deviceId = bTDevice.getDeviceId();
        this.S = bTDevice.getDeviceAddr();
        this.c = bTDevice.getDeviceType();
        this.state = bTDevice.getState();
        this.playerOrder = bTDevice.getPlayerOrder();
        this.isExternal = bTDevice.isExternal();
        this.features = bTDevice.getFeatures();
        this.deviceName = bTDevice.getDeviceName();
        this.isSupportAcc = bTDevice.isSupportAcc();
        this.isSupportGyro = bTDevice.isSupportGyro();
        this.deviceType = bTDevice.getDeviceSource();
        this.accArray = bTDevice.getAccMaxArray();
        this.T = bTDevice.getGycMaxArray();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.deviceId);
        parcel.writeInt(this.c);
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.state);
        parcel.writeInt(this.isExternal ? 1 : 0);
        parcel.writeString(this.S);
        parcel.writeInt(this.features);
        parcel.writeString(this.deviceName);
        parcel.writeInt(this.isSupportAcc ? 1 : 0);
        parcel.writeInt(this.isSupportGyro ? 1 : 0);
    }

    public ControllerDevice(Parcel parcel) {
        this.deviceId = parcel.readInt();
        this.c = parcel.readInt();
        this.playerOrder = parcel.readInt();
        this.state = parcel.readInt();
        this.isExternal = parcel.readInt() == 1;
        this.S = parcel.readString();
        this.features = parcel.readInt();
        this.deviceName = parcel.readString();
        this.isSupportAcc = parcel.readInt() == 1;
        this.isSupportGyro = parcel.readInt() == 1;
    }

    public BTDevice getBTDevice() {
        BTDevice bTDevice = new BTDevice();
        bTDevice.setDeviceAddr(this.S);
        bTDevice.setDeviceName(this.deviceName);
        bTDevice.setDeviceType(this.c);
        bTDevice.setPlayerOrder(this.playerOrder);
        bTDevice.setState(this.state);
        bTDevice.setConnected(this.isConnected());
        bTDevice.setDeviceId(this.deviceId);
        bTDevice.setFeatures(this.features);
        bTDevice.setExternal(this.isExternal);
        bTDevice.setDeviceSource(this.deviceType);
        return bTDevice;
    }

    public boolean isControllerDevice() {
        return this.deviceType == 0 || this.deviceType == 1;
    }

    public String getDeviceTypeDesc() {
        switch (this.deviceType) {
            case 0: {
                return "24g Controller";
            }
            case 1: {
                return "BT Controller";
            }
            case 4: {
                return "DANCE";
            }
            case 3: {
                return "GUN";
            }
            case 5: {
                return "Gesture Glass";
            }
            case 2: {
                return "Bracelet";
            }
            case 11: {
                return "Brain";
            }
            case 6: {
                return "CAMERA";
            }
            case 10: {
                return "Watch";
            }
            case 12: {
                return "Shoe";
            }
            case 8: {
                return "Wheel";
            }
            case 7: {
                return "STICK";
            }
            case 9: {
                return "RING";
            }
        }
        return "UNKOWN";
    }

    public String toString() {
        return "ControllerDevice [deviceType=" + this.deviceType + ", playerOrder=" + this.playerOrder + ", state=" + this.state + ", driverType=" + this.c + ", isExternal=" + this.isExternal + ", deviceId=" + this.deviceId + ", feature=" + this.features + ", address=" + this.S + ", deviceName=" + this.deviceName + ", isSupportAcc=" + this.isSupportAcc + ", isSupportGyro=" + this.isSupportGyro + ", TYPE: " + this.getDeviceTypeDesc() + " MaxAccArray [" + Arrays.toString(this.accArray) + "] MaxGyrArray [" + Arrays.toString(this.T) + "]]";
    }
}

