/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.KeyEvent;
import com.nibiru.lib.controller.BaseEvent;
import java.util.Locale;

public class ControllerKeyEvent
extends BaseEvent
implements Parcelable {
    public static final int KEYCODE_UP = 19;
    public static final int KEYCODE_DOWN = 20;
    public static final int KEYCODE_LEFT = 21;
    public static final int KEYCODE_RIGHT = 22;
    public static final int KEYCODE_UP_LEFT = 125;
    public static final int KEYCODE_UP_RIGHT = 126;
    public static final int KEYCODE_DOWN_LEFT = 127;
    public static final int KEYCODE_DOWN_RIGHT = 128;
    public static final int KEYCODE_BUTTON_Y = 96;
    public static final int KEYCODE_BUTTON_B = 97;
    public static final int KEYCODE_BUTTON_X = 98;
    public static final int KEYCODE_BUTTON_A = 99;
    public static final int KEYCODE_BUTTON_L1 = 102;
    public static final int KEYCODE_BUTTON_R1 = 103;
    public static final int KEYCODE_BUTTON_L2 = 104;
    public static final int KEYCODE_BUTTON_R2 = 105;
    public static final int KEYCODE_BUTTON_THUMBL = 106;
    public static final int KEYCODE_BUTTON_THUMBR = 107;
    public static final int KEYCODE_BUTTON_START = 108;
    public static final int KEYCODE_BUTTON_SELECT = 109;
    public static final int KEYCODE_BUTTON_HOME = 3;
    public static final int KEYCODE_BUTTON_VOL_DOWN = 25;
    public static final int KEYCODE_BUTTON_VOL_UP = 24;
    public static final int KEYCODE_BUTTON_ENTER = 23;
    public static final int KEYCODE_BUTTON_MEDIA_NEXT = 87;
    public static final int KEYCODE_BUTTON_MEDIA_PREVIOUS = 88;
    public static final int KEYCODE_BUTTON_MEDIA_PLAY_PAUSE = 85;
    public static final int KEYCODE_GESTURE_SWING = 170;
    public static final int KEYCODE_SHOW_CURSOR = 171;
    public static final int KEYCODE_TOUCH_TOGGLE = 172;
    public static final int KEYCODE_TOUCH_DOWNUP = 173;
    public static final int KEYCODE_BUTTON_NIBIRU = 110;
    public static final int KEYCODE_IWOWN_KEY_PRESS = 176;
    public static final int KEYCODE_IWOWN_KEY_DOUBLE_PRESS = 177;
    public static final int KEYCODE_IWOWN_KEY_LONG_PRESS = 178;
    public static final int KEYCODE_BUTTON_1 = 201;
    public static final int KEYCODE_BUTTON_2 = 202;
    public static final int KEYCODE_BUTTON_3 = 203;
    public static final int KEYCODE_BUTTON_4 = 204;
    public static final int KEYCODE_BUTTON_5 = 205;
    public static final int KEYCODE_BUTTON_6 = 206;
    public static final int KEYCODE_BUTTON_7 = 207;
    public static final int KEYCODE_BUTTON_8 = 208;
    public static final int KEYCODE_BUTTON_9 = 209;
    public static final int KEYCODE_BUTTON_10 = 210;
    public static final int STATE_CONNING = 0;
    public static final int STATE_CONN = 1;
    public static final int STATE_DISCONNING = 2;
    public static final int STATE_DISCONN = 3;
    public static int[] GameKeys = new int[]{99, 97, 102, 105, 103, 104, 109, 108, 98, 96, 20, 21, 22, 19};
    private int action;
    private int keycode;
    private int playerOrder;
    private long time;
    private long eventTime;
    private boolean isExternal = false;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new ControllerKeyEvent(parcel);
        }
    };

    public ControllerKeyEvent() {
    }

    public ControllerKeyEvent(int n2, int n3, int n4) {
        this.action = n2;
        this.keycode = n3;
        this.playerOrder = n4;
        this.time = SystemClock.uptimeMillis();
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int n2) {
        this.action = n2;
    }

    public int getKeyCode() {
        return this.keycode;
    }

    public void setKeyCode(int n2) {
        this.keycode = n2;
    }

    @Override
    public int getPlayerOrder() {
        return this.playerOrder;
    }

    @Override
    public void setPlayerOrder(int n2) {
        this.playerOrder = n2;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public KeyEvent getKeyEvent() {
        return new KeyEvent(this.time, SystemClock.uptimeMillis(), this.action, this.keycode, 0, 0, 65535, 0, 2);
    }

    public KeyEvent getKeyEvent(int n2, int n3, int n4) {
        return new KeyEvent(this.time, SystemClock.uptimeMillis(), this.action, this.keycode, 0, n2, n3, n4, 2);
    }

    public KeyEvent getJoystickKeyEvent(int n2, int n3) {
        if (n2 <= 0) {
            n2 = this.keycode;
        }
        return new KeyEvent(this.time, this.time, this.action, n2, 0, 32768, 65535, n3, 8);
    }

    public KeyEvent getKeyEvent(int n2, int n3) {
        if (n2 <= 0 || n2 > 255) {
            n2 = this.keycode;
        }
        return new KeyEvent(this.time, SystemClock.uptimeMillis(), this.action, n2, 0, 32768, 65535, n3, 2);
    }

    public static String getInputStr(KeyEvent keyEvent) {
        return String.valueOf(keyEvent.getAction()) + " " + keyEvent.getKeyCode();
    }

    public static KeyEvent getKeyEvent2(int n2, int n3) {
        if (n3 < 0 || n3 > 255) {
            return null;
        }
        long l2 = SystemClock.uptimeMillis();
        return new KeyEvent(l2, SystemClock.uptimeMillis(), n2, n3, 0, 32768, 65535, 0, 8);
    }

    public static KeyEvent getKeyEvent2(int n2, int n3, int n4) {
        if (n3 < 0 || n3 > 255) {
            return null;
        }
        long l2 = SystemClock.uptimeMillis();
        return new KeyEvent(l2, SystemClock.uptimeMillis(), n2, n3, 0, 32768, n4, 0, 8);
    }

    public static KeyEvent getKeyEvent3(int n2, int n3, int n4, long l2) {
        if (n3 < 0 || n3 > 255) {
            return null;
        }
        return new KeyEvent(l2, l2, n2, n3, 0, 32768, n4, 0, 8);
    }

    public static KeyEvent getKeyEvent4(int n2, int n3, int n4, int n5, long l2) {
        if (n3 < 0 || n3 > 255) {
            return null;
        }
        return new KeyEvent(l2, l2, n2, n3, 0, n5, n4, 0, 8);
    }

    public static KeyEvent getKeyEventInternal(int n2, int n3, int n4) {
        if (n3 < 0 || n3 > 255) {
            return null;
        }
        long l2 = SystemClock.uptimeMillis();
        return new KeyEvent(l2, SystemClock.uptimeMillis(), n2, n3, 0, 0, n4, 0, 8);
    }

    public void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    public ControllerKeyEvent(Parcel parcel) {
        this.action = parcel.readInt();
        this.keycode = parcel.readInt();
        this.playerOrder = parcel.readInt();
        this.time = parcel.readLong();
        this.isExternal = parcel.readInt() == 1;
    }

    public ControllerKeyEvent(ControllerKeyEvent controllerKeyEvent) {
        this.keycode = controllerKeyEvent.keycode;
        this.action = controllerKeyEvent.action;
        this.playerOrder = controllerKeyEvent.playerOrder;
        this.time = controllerKeyEvent.time;
        this.isExternal = controllerKeyEvent.isExternal;
    }

    public ControllerKeyEvent(int n2, KeyEvent keyEvent, int n3) {
        this.action = keyEvent.getAction();
        this.keycode = n3 > 0 ? n3 : keyEvent.getKeyCode();
        this.playerOrder = n2;
        this.time = keyEvent.getDownTime();
    }

    @Override
    public long getEventTime() {
        return this.eventTime;
    }

    @Override
    public void setEventTime(long l2) {
        this.eventTime = l2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.action);
        parcel.writeInt(this.keycode);
        parcel.writeInt(this.playerOrder);
        parcel.writeLong(this.time);
        parcel.writeInt(this.isExternal ? 1 : 0);
    }

    public String toString() {
        return "ControllerKeyEvent [" + this.descriptionKey() + " action=" + this.action + ", keycode=" + this.keycode + ", playerOrder=" + this.playerOrder + ", time=" + this.time + ", evenTime=" + this.eventTime + ", delay: " + (this.eventTime - this.time) + "ms ]";
    }

    public String descriptionKey() {
        return ControllerKeyEvent.descriptionKey(this.keycode);
    }

    public boolean isValidKeyEvent(ControllerKeyEvent controllerKeyEvent) {
        if (controllerKeyEvent.getAction() != this.action) {
            return true;
        }
        if (this.keycode != controllerKeyEvent.getKeyCode()) {
            return true;
        }
        return Math.abs(this.time - controllerKeyEvent.getTime()) > 300L;
    }

    public int hashCode() {
        int n2 = 31 + this.action;
        n2 = n2 * 31 + this.keycode;
        n2 = n2 * 31 + this.playerOrder;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ControllerKeyEvent)object;
        if (this.action != ((ControllerKeyEvent)object).action) {
            return false;
        }
        if (this.keycode != ((ControllerKeyEvent)object).keycode) {
            return false;
        }
        return this.playerOrder == ((ControllerKeyEvent)object).playerOrder;
    }

    public static boolean isNibiruControllerSupportKeyCode(int n2) {
        switch (n2) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 85: 
            case 87: 
            case 88: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 171: 
            case 172: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGoogleControllerSupportKeyCode(int n2) {
        switch (n2) {
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemKeyCode(int n2) {
        switch (n2) {
            case 3: 
            case 4: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 82: 
            case 111: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemExKeyCode(int n2) {
        switch (n2) {
            case 3: 
            case 4: 
            case 24: 
            case 25: 
            case 26: 
            case 111: 
            case 164: 
            case 187: {
                return true;
            }
        }
        return false;
    }

    public static String descriptionKey(int n2) {
        switch (n2) {
            case 99: {
                return "KEYCODE_BUTTON_A";
            }
            case 97: {
                return "KEYCODE_BUTTON_B";
            }
            case 98: {
                return "KEYCODE_BUTTON_X";
            }
            case 96: {
                return "KEYCODE_BUTTON_Y";
            }
            case 102: {
                return "KEYCODE_BUTTON_L1";
            }
            case 104: {
                return "KEYCODE_BUTTON_L2";
            }
            case 103: {
                return "KEYCODE_BUTTON_R1";
            }
            case 105: {
                return "KEYCODE_BUTTON_R2";
            }
            case 21: {
                return "KEYCODE_LEFT";
            }
            case 22: {
                return "KEYCODE_RIGHT";
            }
            case 19: {
                return "KEYCODE_UP";
            }
            case 20: {
                return "KEYCODE_DOWN";
            }
            case 125: {
                return "KEYCODE_UP_LEFT";
            }
            case 126: {
                return "KEYCODE_UP_RIGHT";
            }
            case 127: {
                return "KEYCODE_DOWN_LEFT";
            }
            case 128: {
                return "KEYCODE_DOWN_RIGHT";
            }
            case 109: {
                return "KEYCODE_BUTTON_SELECT";
            }
            case 108: {
                return "KEYCODE_BUTTON_START";
            }
            case 3: {
                return "KEYCODE_BUTTON_HOME";
            }
            case 23: {
                return "KEYCODE_BUTTON_ENTER";
            }
            case 170: {
                return "KEYCODE_GESTURE_SWING";
            }
            case 110: {
                return "KEYCODE_BUTTON_NIBIRU";
            }
            case 177: {
                return "KEYCODE_IWOWN_KEY_DOUBLE_PRESS";
            }
            case 178: {
                return "KEYCODE_IWOWN_KEY_LONG_PRESS";
            }
            case 176: {
                return "KEYCODE_IWOWN_KEY_PRESS";
            }
            case 87: {
                return "KEYCODE_BUTTON_MEDIA_NEXT";
            }
            case 88: {
                return "KEYCODE_MEDIA_PREVIOUS";
            }
            case 85: {
                return "KEYCODE_MEDIA_PLAY_PAUSE";
            }
            case 106: {
                return "KEYCODE_BUTTON_THUMBL";
            }
            case 107: {
                return "KEYCODE_BUTTON_THUMBR";
            }
            case 25: {
                return "KEYCODE_BUTTON_VOL_DOWN";
            }
            case 24: {
                return "KEYCODE_BUTTON_VOL_UP";
            }
            case 201: {
                return "KEYCODE_BUTTON_1";
            }
            case 202: {
                return "KEYCODE_BUTTON_2";
            }
            case 203: {
                return "KEYCODE_BUTTON_3";
            }
            case 204: {
                return "KEYCODE_BUTTON_4";
            }
            case 205: {
                return "KEYCODE_BUTTON_5";
            }
            case 206: {
                return "KEYCODE_BUTTON_6";
            }
            case 207: {
                return "KEYCODE_BUTTON_7";
            }
            case 208: {
                return "KEYCODE_BUTTON_8";
            }
            case 209: {
                return "KEYCODE_BUTTON_9";
            }
            case 210: {
                return "KEYCODE_BUTTON_10";
            }
        }
        return "UNKNOWN BUTTON";
    }

    public boolean isArrow() {
        return this.keycode >= 19 && this.keycode <= 22;
    }

    public static int getNibiruKeyCode(int n2) {
        switch (n2) {
            case 99: {
                return 98;
            }
            case 100: {
                return 96;
            }
            case 96: {
                return 99;
            }
            case 97: {
                return 97;
            }
            case 104: {
                return 104;
            }
            case 105: {
                return 105;
            }
            case 102: {
                return 102;
            }
            case 103: {
                return 103;
            }
            case 109: {
                return 109;
            }
            case 108: {
                return 108;
            }
            case 106: {
                return 106;
            }
            case 107: {
                return 107;
            }
            case 87: {
                return 87;
            }
            case 88: {
                return 88;
            }
            case 85: {
                return 85;
            }
        }
        return n2;
    }

    public static int getGoogleKeyCode(int n2) {
        switch (n2) {
            case 98: {
                return 99;
            }
            case 96: {
                return 100;
            }
            case 99: {
                return 96;
            }
            case 97: {
                return 97;
            }
        }
        return n2;
    }

    @Override
    public String getUnityMessage() {
        return String.format(Locale.US, "%d %d %d", this.playerOrder, this.keycode, this.action);
    }
}

