/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.NativeActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.controller.C;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.GlobalLog;
import com.nibiru.lib.controller.OnKeyListener;
import com.nibiru.lib.controller.StickSimService;
import com.nibiru.lib.controller.VRTipActivity;

public class ExVRUnityGameActivity
extends NativeActivity
implements OnKeyListener {
    protected static final String TAG = "NIBIRU SDK";
    private ControllerService mControllerService;
    private boolean dQ = false;
    protected boolean isSupportNibiruControl = true;

    protected void onCreate(Bundle object) {
        super.onCreate(object);
        this.mControllerService = Controller.getControllerService((Context)this);
        this.mControllerService.setKeyListener(this);
        this.mControllerService.setSDKMode(3);
        object = new StickSimService.StickSimConfig(0, 1);
        this.mControllerService.getStickSimService().startStickSim((StickSimService.StickSimConfig)object);
        this.mControllerService.getDpadService().startDpadMode(1);
        this.mControllerService.setControllerServiceListener(new ControllerService.OnControllerSeviceListener(this){

            @Override
            public final void onControllerServiceReady(boolean bl) {
                GlobalLog.d("EX  UNITY REG RESULT: " + bl);
            }
        });
        try {
            this.mControllerService.register();
            return;
        }
        catch (ControllerServiceException controllerServiceException) {
            object = controllerServiceException;
            controllerServiceException.printStackTrace();
            return;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
            this.mControllerService = null;
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(false);
        }
        this.getWindow().clearFlags(128);
    }

    protected void onResume() {
        super.onResume();
        this.getWindow().setFlags(128, 128);
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(true);
        }
    }

    @Override
    public void onControllerKeyDown(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
        GlobalLog.d("ON CONTROLLER KEY DOWN: " + n3);
        if (n3 == 109) {
            this.requestClose(n3);
            return;
        }
        if (n3 == 108 && this.mControllerService != null) {
            if (!this.mControllerService.getCursorService().isCursorShow()) {
                n2 = this.getResources().getIdentifier("arrow", "drawable", this.getPackageName());
                if (n2 > 0) {
                    this.mControllerService.getCursorService().createCursor(n2);
                    return;
                }
                Log.e((String)TAG, (String)"CANNOT FOUND RESOURCE");
                return;
            }
            this.mControllerService.getCursorService().hideCursor();
        }
    }

    @Override
    public void onControllerKeyUp(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        GlobalLog.d("DISPATCH IN UNITY: " + keyEvent);
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)keyEvent)) {
            return true;
        }
        if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 4) {
            this.requestClose(keyEvent.getKeyCode());
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)motionEvent)) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        if (n2 == 100) {
            this.dQ = false;
        }
        if (n2 == 100 && n3 == 101) {
            this.finish();
            Process.killProcess((int)Process.myPid());
        }
    }

    public void requestClose(int n2) {
        GlobalLog.d("ex unity req close");
        if (!this.isSupportNibiruControl) {
            return;
        }
        if (this.dQ) {
            return;
        }
        this.dQ = true;
        Intent intent = new Intent((Context)this, VRTipActivity.class);
        intent.putExtra("textStr", C.o((Context)this) == 1 ? "\u518d\u6309\u4e00\u6b21\u786e\u8ba4\u9000\u51fa" : "Press again to exit");
        intent.putExtra("delay", 3000);
        intent.putExtra("closeKey", n2);
        this.startActivityForResult(intent, 100);
    }
}

