/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.NativeActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.GlobalLog;
import com.nibiru.lib.controller.OnKeyListener;
import com.nibiru.lib.controller.OnSimpleStickListener;
import com.nibiru.lib.controller.p;

public class NativeControllerActivity
extends NativeActivity
implements OnKeyListener,
OnSimpleStickListener {
    protected static final String TAG = "NIBIRU SDK";
    private ControllerService mControllerService;
    private p as;

    protected void onCreate(Bundle object) {
        super.onCreate(object);
        this.mControllerService = Controller.getControllerService((Context)this);
        this.mControllerService.setKeyListener(this);
        this.mControllerService.setSimpleStickListener(this);
        this.as = this.mControllerService.getExitManager();
        this.mControllerService.setControllerServiceListener(new ControllerService.OnControllerSeviceListener(this){

            @Override
            public final void onControllerServiceReady(boolean bl) {
                GlobalLog.d("Nibiru REG RESULT: " + bl);
            }
        });
        try {
            this.mControllerService.register();
            return;
        }
        catch (ControllerServiceException controllerServiceException) {
            object = controllerServiceException;
            controllerServiceException.printStackTrace();
            return;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
            this.mControllerService = null;
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(false);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(true);
        }
    }

    @Override
    public void onControllerKeyDown(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
        GlobalLog.d("ON CONTROLLER KEY DOWN: " + n3);
        if (this.as != null && this.as.d(n3, controllerKeyEvent.getAction())) {
            return;
        }
    }

    @Override
    public void onControllerKeyUp(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        GlobalLog.d("DISPATCH IN UNITY: " + keyEvent);
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)keyEvent)) {
            return true;
        }
        if (this.as != null && this.as.d(keyEvent.getKeyCode(), keyEvent.getAction())) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)motionEvent)) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (this.as != null && this.as.e(n2, n3)) {
            return;
        }
        super.onActivityResult(n2, n3, intent);
    }

    @Override
    public void onLeftStickChanged(int n2, float f2, float f3) {
    }

    @Override
    public void onRightStickChanged(int n2, float f2, float f3) {
    }
}

