/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Base64;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.controller.AccEvent;
import com.nibiru.lib.controller.CombKeyService;
import com.nibiru.lib.controller.ContinuesKeyService;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerDevice;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.CursorService;
import com.nibiru.lib.controller.DpadService;
import com.nibiru.lib.controller.GyroEvent;
import com.nibiru.lib.controller.MotionSenseEvent;
import com.nibiru.lib.controller.OnAccListener;
import com.nibiru.lib.controller.OnGyroListener;
import com.nibiru.lib.controller.OnKeyListener;
import com.nibiru.lib.controller.OnMotionSenseListener;
import com.nibiru.lib.controller.OnSimpleStickListener;
import com.nibiru.lib.controller.OnStateListener;
import com.nibiru.lib.controller.OnStickListener;
import com.nibiru.lib.controller.OnTouchListener;
import com.nibiru.lib.controller.StickEvent;
import com.nibiru.lib.controller.StickSimService;
import com.nibiru.lib.controller.TouchEvent;
import com.nibiru.lib.controller.p;
import com.nibiru.lib.controller.s;

public class SimpleControllerActivity
extends Activity
implements CombKeyService.OnCombKeyListener,
ControllerService.OnControllerSeviceListener,
OnAccListener,
OnGyroListener,
OnKeyListener,
OnMotionSenseListener,
OnSimpleStickListener,
OnStateListener,
OnStickListener,
OnTouchListener {
    protected ControllerService mControllerService;
    protected CombKeyService mCombKeyService;
    protected StickSimService mStickSimService;
    protected ContinuesKeyService mContinuesKeyService;
    protected CursorService mCursorService;
    protected DpadService mDpadService;
    private p as;
    private boolean gI = false;
    protected int mArrowId = -1;
    protected int mMouseStartKey = 108;
    protected boolean isVRMode = false;
    protected boolean isAutoCheckDriver = true;

    protected void onCreate(Bundle object) {
        super.onCreate((Bundle)object);
        object = this;
        this.mControllerService = Controller.getControllerService((Context)object);
        if (((SimpleControllerActivity)object).isVRMode) {
            ((SimpleControllerActivity)object).mControllerService.setVRMode(((SimpleControllerActivity)object).isVRMode);
        }
        ((SimpleControllerActivity)object).mCombKeyService = ((SimpleControllerActivity)object).mControllerService.getCombKeyService();
        ((SimpleControllerActivity)object).mStickSimService = ((SimpleControllerActivity)object).mControllerService.getStickSimService();
        ((SimpleControllerActivity)object).mContinuesKeyService = ((SimpleControllerActivity)object).mControllerService.getContinusKeyService();
        ((SimpleControllerActivity)object).mCursorService = ((SimpleControllerActivity)object).mControllerService.getCursorService();
        ((SimpleControllerActivity)object).mDpadService = ((SimpleControllerActivity)object).mControllerService.getDpadService();
        ((SimpleControllerActivity)object).mControllerService.setKeyListener((OnKeyListener)object);
        ((SimpleControllerActivity)object).mControllerService.setStickListener((OnStickListener)object);
        ((SimpleControllerActivity)object).mControllerService.setSimpleStickListener((OnSimpleStickListener)object);
        ((SimpleControllerActivity)object).mControllerService.setStateListener((OnStateListener)object);
        ((SimpleControllerActivity)object).mControllerService.setControllerServiceListener((ControllerService.OnControllerSeviceListener)object);
        ((SimpleControllerActivity)object).mControllerService.setAccListener((OnAccListener)object);
        ((SimpleControllerActivity)object).mControllerService.setGyroListener((OnGyroListener)object);
        ((SimpleControllerActivity)object).mControllerService.setMotionSenseListener((OnMotionSenseListener)object);
        ((SimpleControllerActivity)object).mControllerService.setTouchListener((OnTouchListener)object);
        ((SimpleControllerActivity)object).as = ((SimpleControllerActivity)object).mControllerService.getExitManager();
        ((SimpleControllerActivity)object).mCombKeyService.setCombKeyListener((CombKeyService.OnCombKeyListener)object);
        ((SimpleControllerActivity)object).mContinuesKeyService.registerContinuesDirectionKey();
        ((SimpleControllerActivity)object).mControllerService.setEnableL2R2(true);
        ((SimpleControllerActivity)object).mCursorService.setSensitivity(20, 10);
        ((SimpleControllerActivity)object).mCursorService.setEnableDisplayAtPrePos(true);
        ((SimpleControllerActivity)object).mCursorService.setHideKey(108);
        ((SimpleControllerActivity)object).mControllerService.setHandler(new Handler());
        if (((SimpleControllerActivity)object).mControllerService != null && !((SimpleControllerActivity)object).mControllerService.isServiceEnable()) {
            ((SimpleControllerActivity)object).initNibiruService();
        }
    }

    protected void initNibiruService() {
        try {
            this.mControllerService.register();
            return;
        }
        catch (ControllerServiceException controllerServiceException) {
            ControllerServiceException controllerServiceException2 = controllerServiceException;
            controllerServiceException.printStackTrace();
            return;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
            this.mControllerService = null;
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.onPause();
        }
    }

    public void startCursorMode(int n2) {
        this.getCursorSerivce().createCursor(n2);
    }

    public void setCursorSensitivity(int n2, int n3) {
        if (this.mCursorService != null) {
            this.mCursorService.setSensitivity(n2, n3);
        }
    }

    public void setCursorStartKey(int n2) {
        this.mMouseStartKey = n2;
        if (this.mCursorService != null) {
            this.mCursorService.setHideKey(n2);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mControllerService != null) {
            this.mControllerService.onResume();
            this.mControllerService.handleFullScreenMode();
        }
    }

    private void A(boolean bl) {
        if (this.mStickSimService == null) {
            return;
        }
        if (bl) {
            this.mStickSimService.startStickSim(this.mStickSimService.getStickSimConfig());
            return;
        }
        this.mStickSimService.stopStickSim();
    }

    public void setEnableL2R2(boolean bl) {
        if (this.mControllerService != null) {
            this.mControllerService.setEnableL2R2(bl);
        }
    }

    public void setEnterKeyCode(int n2) {
        if (this.mControllerService != null) {
            this.mControllerService.setEnterKeyCode(n2);
        }
    }

    public void disableStickSim() {
        this.A(false);
    }

    public void enableStickSimDir8() {
        if (this.mStickSimService != null) {
            this.mStickSimService.setKeyNum(1);
        }
        this.A(true);
    }

    public void enableStickSimDir4() {
        if (this.mStickSimService != null) {
            this.mStickSimService.setKeyNum(0);
        }
        this.A(true);
    }

    public void showGameGuide(boolean bl) {
        if (this.mControllerService == null) {
            return;
        }
        this.mControllerService.showGameGuide(bl);
    }

    public boolean hasDeviceConnected() throws ControllerServiceException {
        if (this.mControllerService == null) {
            throw new ControllerServiceException("Controller Service is not connected to driver, please install your driver first and wait for connection build");
        }
        return this.mControllerService.hasDeviceConnected();
    }

    public void setArrowResId(int n2) {
        this.mArrowId = n2;
        if (this.mCursorService != null) {
            this.mCursorService.setCursorResource(n2);
        }
    }

    protected void setScreenOnMode(boolean bl) {
        if (bl) {
            this.getWindow().clearFlags(128);
            this.getWindow().setFlags(128, 128);
            return;
        }
        this.getWindow().clearFlags(128);
    }

    @Override
    public void onControllerStateChanged(int n2, int n3, ControllerDevice controllerDevice) {
    }

    @Override
    public void onBluetoothStateChanged(int n2) {
    }

    @Override
    public void onControllerStickEvent(int n2, StickEvent stickEvent) {
    }

    @Override
    public void onControllerKeyDown(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
        if (this.as != null && this.as.d(n3, controllerKeyEvent.getAction())) {
            return;
        }
        if (this.mMouseStartKey > 0 && n3 == this.mMouseStartKey && this.mCursorService != null) {
            if (this.mCursorService.isCursorShow()) {
                this.mCursorService.hideCursor();
                return;
            }
            if (this.mArrowId >= 0) {
                this.mCursorService.createCursor(this.mArrowId);
                return;
            }
            if (!this.mCursorService.isCursorResReady()) {
                this.mCursorService.setDefaultCursorRes();
                if (!this.mCursorService.isCursorResReady()) {
                    this.mCursorService.setCursorBitmap(s.a(Base64.decode((String)"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", (int)0)));
                }
            }
            this.mCursorService.createCursor();
        }
    }

    @Override
    public void onControllerKeyUp(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
    }

    public boolean isControllerServiceEnable() {
        return this.gI;
    }

    public ControllerService getControllerService() {
        return this.mControllerService;
    }

    public CombKeyService getCombKeyService() {
        return this.mCombKeyService;
    }

    public StickSimService getStickSimService() {
        return this.mStickSimService;
    }

    public ContinuesKeyService getContinuesKeyService() {
        return this.mContinuesKeyService;
    }

    public CursorService getCursorSerivce() {
        return this.mCursorService;
    }

    public DpadService getDpadService() {
        return this.mDpadService;
    }

    @Override
    public void onCombKeyEventStart(String string, int n2, CombKeyService.CombKey combKey) {
    }

    @Override
    public void onCombKeyEventOver(String string, int n2, CombKeyService.CombKey combKey) {
    }

    @Override
    public void onControllerServiceReady(boolean bl) {
        this.gI = bl;
    }

    @Override
    public void onControllerGyroEvent(int n2, GyroEvent gyroEvent) {
    }

    @Override
    public void onControllerAccEvent(int n2, AccEvent accEvent) {
    }

    @Override
    public void onLeftStickChanged(int n2, float f2, float f3) {
    }

    @Override
    public void onRightStickChanged(int n2, float f2, float f3) {
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)keyEvent)) {
            return true;
        }
        if (this.as != null && this.as.d(keyEvent.getKeyCode(), keyEvent.getAction())) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)motionEvent)) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    @Override
    public void onMotionSenseChanged(int n2, MotionSenseEvent motionSenseEvent) {
    }

    @Override
    public void onTouch(int n2, int n3, TouchEvent touchEvent) {
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (this.as != null && this.as.e(n2, n3)) {
            return;
        }
        super.onActivityResult(n2, n3, intent);
    }

    protected void onStart() {
        super.onStart();
        if (this.mControllerService != null) {
            this.mControllerService.onStart();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mControllerService != null) {
            this.mControllerService.onStop();
        }
    }
}

