/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.spec;

import android.os.Bundle;
import com.nibiru.lib.controller.I;
import com.nibiru.lib.spec.b;
import java.util.Arrays;
import java.util.Locale;

public class GestureEvent
extends b {
    public static final int GESTURE_SLIP_LEFT = 301;
    public static final int GESTURE_SLIP_RIGHT = 302;
    public static final int GESTURE_SLIP_UP = 303;
    public static final int GESTURE_SLIP_DOWN = 304;
    public static final int GESTURE_CLOCKWISE = 305;
    public static final int GESTURE_COUNTERCLOCKWISE = 306;
    public static final int GESTURE_ENTER = 307;
    public static final int GESTURE_SINGLE_TOUCH = 308;
    public static final int GESTURE_DOUBLE_TOUCH = 309;
    public static final int GESTURE_LONG_PRESS = 310;
    public static final int GESTURE_SWING = 311;

    public GestureEvent(int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.setEventType(101);
    }

    public GestureEvent(Bundle bundle) {
        super(bundle);
    }

    public GestureEvent(GestureEvent gestureEvent) {
        this(gestureEvent.identify, gestureEvent.playerOrder, gestureEvent.deviceId);
    }

    public String toString() {
        return "GestureEvent [ID=" + this.getGestureDesc() + " playerOrder=" + this.playerOrder + ", deviceId=" + this.deviceId + ", eventTime=" + this.eventTime + ", eventType=" + this.eventType + ", data=" + this.data + ", isValid=" + this.isValid + "]";
    }

    public String getGestureDesc() {
        switch (this.identify) {
            case 301: {
                return "SLIP LEFT";
            }
            case 302: {
                return "SLIP RIGHT";
            }
            case 303: {
                return "SLIP UP";
            }
            case 304: {
                return "SLIP DOWN";
            }
            case 305: {
                return "CLOCKWISE";
            }
            case 306: {
                return "COUNTER CLOCKWISE";
            }
            case 307: {
                return "ENTER";
            }
            case 308: {
                return "SINGLE TOUCH";
            }
            case 309: {
                return "DOUBLE TOUCH";
            }
            case 310: {
                return "LONG PRESS";
            }
            case 311: {
                return "SWING";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public String getUnityMessage() {
        return String.format(Locale.US, "%d %d", this.identify, this.playerOrder);
    }

    public byte[] getSendBytes() {
        byte[] byArray;
        byte[] byArray2 = new byte[101];
        Arrays.fill(byArray2, (byte)0);
        byArray2[0] = -1;
        byArray2[1] = -1;
        int n2 = 2;
        int n3 = this.playerOrder;
        byArray2[2] = I.A(n3);
        ++n2;
        byte[] byArray3 = byArray = I.z(this.identify);
        int n4 = byArray.length;
        int n5 = 0;
        while (n5 < n4) {
            byte by;
            byArray2[n2] = by = byArray3[n5];
            ++n2;
            ++n5;
        }
        return byArray2;
    }
}

