package com.nibiru.lib.controller;

import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.StickEvent;
import com.nibiru.lib.controller.AccEvent;
import com.nibiru.lib.controller.GyroEvent;
import com.nibiru.lib.BTDevice;

interface IBluexListener{
void onKeyEvent(in ControllerKeyEvent[] event);
void onStickEvent(in StickEvent[] event);
void onControllerStateChange(int player, int state, in BTDevice device);
void onBluetoothStateChange(int state);
void onErrorReportReady(int type, String path);
void onError(String errorInfo);
int isEnable();
int isIME();
String getPackageName();
void onAccEvent(in AccEvent[] event);
void onGyroEvent(in GyroEvent[] event);
void onKeyStateUpdate(int player, in int[] keyState);
void onInputViewResult(String content,int resCode);
void onVirtualServiceState(int state);
void onExternalDeviceUpdate(in BTDevice[] device);
void setCursorModeForce(boolean isStart);
String getToken();
boolean isCursorReady();
boolean isEnableLR2();
void onCursorSpeedChanged(int step, int delay);
int[] getCurrentCursorState();
boolean isCursorShow();
int getEnterKeyCode();
void onMotionSenseDataChanged(in Bundle bundle);
Bundle getState();
void onRevCtrlCmd(in Bundle cmd);
void onTouchEvent(in Bundle bundle);
void onMouseEvent(in Bundle bundle);
Bundle[] getBundleData(in Bundle cmd);
void onSpecicalEvent(in Bundle event);
void onPoseEvent(in Bundle event);
}