/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OuyaController {
    public static final int BUTTON_O = 96;
    public static final int BUTTON_U = 99;
    public static final int BUTTON_Y = 100;
    public static final int BUTTON_A = 97;
    public static final int BUTTON_L1 = 102;
    @Deprecated
    public static final int BUTTON_L2 = 104;
    public static final int BUTTON_R1 = 103;
    @Deprecated
    public static final int BUTTON_R2 = 105;
    public static final int BUTTON_MENU = 82;
    public static final int BUTTON_HOME = 3;
    public static final int AXIS_LS_X = 0;
    public static final int AXIS_LS_Y = 1;
    public static final int AXIS_RS_X = 11;
    public static final int AXIS_RS_Y = 14;
    public static final int AXIS_L2 = 17;
    public static final int AXIS_R2 = 18;
    public static final int BUTTON_DPAD = 23;
    public static final int BUTTON_DPAD_UP = 19;
    public static final int BUTTON_DPAD_RIGHT = 22;
    public static final int BUTTON_DPAD_DOWN = 20;
    public static final int BUTTON_DPAD_LEFT = 21;
    public static final int BUTTON_R3 = 107;
    public static final int BUTTON_L3 = 106;
    private static int[] AVAILABLE_AXES = new int[]{0, 1, 11, 14, 17, 18};
    public static final int MAX_CONTROLLERS = 4;
    public static final float STICK_DEADZONE = 0.25f;
    private static final String LOG_TAG = "OuyaController";
    private static final String OUYA_CONTROLLER_ADDED_ACTION = "tv.ouya.controller.added";
    private static final String OUYA_CONTROLLER_REMOVED_ACTION = "tv.ouya.controller.removed";
    private static final String EXTRA_OUYA_CONTROLLER_DEVICE_ID = "DEVICE_ID";
    private static final String EXTRA_OUYA_CONTROLLER_PLAYER_NUM = "PLAYER_NUM";
    private static final int INVALID_INPUT_DEVICE_ID = -1;
    private static final Uri sControllerUri = Uri.parse((String)"content://tv.ouya.controllerdata/");
    private static Context appContext;
    private static Bundle sButtonDataBundle;
    private static SparseArray<ButtonData> sButtonDataCache;
    static final OuyaController[] s_controllers;
    private int deviceId;
    private InputDevice device;
    private String deviceName;
    private SparseArray<Float> axisValues;
    private SparseBooleanArray buttonValues;
    private static final int PRESSED_THIS_FRAME = 1;
    private static final int RELEASED_THIS_FRAME = 2;
    private SparseIntArray thisFrameButtonValues;

    public static void init(Context context) {
        if (appContext != null) {
            return;
        }
        appContext = context.getApplicationContext();
        for (int i = 0; i < 4; ++i) {
            int deviceId = OuyaController.getDeviceIdFromPlayerNum(i);
            if (deviceId == -1) continue;
            OuyaController.getOrCreateControllerByDeviceId(deviceId);
        }
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals(OuyaController.OUYA_CONTROLLER_ADDED_ACTION)) {
                    int deviceId = intent.getIntExtra(OuyaController.EXTRA_OUYA_CONTROLLER_DEVICE_ID, -1);
                    int playerNum = intent.getIntExtra(OuyaController.EXTRA_OUYA_CONTROLLER_PLAYER_NUM, -1);
                    if (playerNum < 0 || playerNum >= 4) {
                        return;
                    }
                    if (s_controllers[playerNum] != null) {
                        Log.e((String)OuyaController.LOG_TAG, (String)("Controller already exists for player " + playerNum + "(new device id " + deviceId + ", prev device id " + s_controllers[playerNum].getDeviceId() + ")"));
                    }
                    OuyaController.s_controllers[playerNum] = new OuyaController(deviceId);
                } else if (intent.getAction().equals(OuyaController.OUYA_CONTROLLER_REMOVED_ACTION)) {
                    int deviceId = intent.getIntExtra(OuyaController.EXTRA_OUYA_CONTROLLER_DEVICE_ID, -1);
                    for (int i = 0; i < 4; ++i) {
                        OuyaController controller = s_controllers[i];
                        if (controller == null || controller.getDeviceId() != deviceId) continue;
                        OuyaController.s_controllers[i] = null;
                        break;
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction(OUYA_CONTROLLER_ADDED_ACTION);
        filter.addAction(OUYA_CONTROLLER_REMOVED_ACTION);
        appContext.registerReceiver(receiver, filter);
    }

    public static ButtonData getButtonData(int ouyaButton) {
        ButtonData cachedButtonData;
        if (sButtonDataCache != null && (cachedButtonData = (ButtonData)sButtonDataCache.get(ouyaButton)) != null) {
            return cachedButtonData;
        }
        if (sButtonDataBundle == null) {
            ContentResolver contentResolver = appContext.getContentResolver();
            try {
                sButtonDataBundle = contentResolver.call(sControllerUri, "get_button_images", null, null);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)LOG_TAG, (String)"Error querying button remapping");
                return null;
            }
        }
        String buttonValueStr = String.valueOf(ouyaButton);
        Drawable drawable = null;
        try {
            AssetFileDescriptor afd = (AssetFileDescriptor)sButtonDataBundle.get(buttonValueStr);
            FileInputStream is = afd != null ? afd.createInputStream() : null;
            drawable = Drawable.createFromStream((InputStream)is, (String)buttonValueStr);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)("IOException: " + e.getMessage()));
        }
        String buttonName = sButtonDataBundle.getString(buttonValueStr + "_name");
        ButtonData buttonData = new ButtonData(drawable, buttonName);
        if (sButtonDataCache == null) {
            sButtonDataCache = new SparseArray();
        }
        sButtonDataCache.put(ouyaButton, (Object)buttonData);
        return buttonData;
    }

    public static OuyaController getControllerByDeviceId(int deviceId) {
        for (OuyaController c : s_controllers) {
            if (c == null || c.getDeviceId() != deviceId) continue;
            return c;
        }
        return null;
    }

    public static int getPlayerNumByDeviceId(int deviceId) {
        OuyaController controller = OuyaController.getOrCreateControllerByDeviceId(deviceId);
        if (controller == null) {
            return -1;
        }
        return controller.getPlayerNum();
    }

    public static OuyaController getControllerByPlayer(int playerNum) {
        if (playerNum >= 0 && playerNum < 4) {
            return s_controllers[playerNum];
        }
        return null;
    }

    public static boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 0x10) == 0) {
            return false;
        }
        if (event.getAction() != 2) {
            return false;
        }
        OuyaController device = OuyaController.getOrCreateControllerByDeviceId(event.getDeviceId());
        if (device == null) {
            return false;
        }
        for (int ouyaAxis : AVAILABLE_AXES) {
            Float curValue = (Float)device.axisValues.get(ouyaAxis);
            float newValue = event.getAxisValue(ouyaAxis);
            if (curValue != null && curValue.floatValue() == newValue) continue;
            device.axisValues.put(ouyaAxis, (Object)Float.valueOf(newValue));
        }
        return true;
    }

    public static boolean onKeyDown(int keyCode, KeyEvent event) {
        return OuyaController.onKeyEvent(keyCode, event);
    }

    public static boolean onKeyUp(int keyCode, KeyEvent event) {
        return OuyaController.onKeyEvent(keyCode, event);
    }

    private static boolean onKeyEvent(int keyCode, KeyEvent event) {
        OuyaController device = OuyaController.getOrCreateControllerByDeviceId(event.getDeviceId());
        if (device == null) {
            return false;
        }
        boolean newVal = false;
        switch (event.getAction()) {
            case 0: 
            case 2: {
                newVal = true;
                break;
            }
            case 1: {
                newVal = false;
            }
        }
        int ouyaButton = event.getKeyCode();
        if (device.buttonValues.indexOfKey(ouyaButton) < 0 || device.buttonValues.get(ouyaButton) != newVal) {
            int flags = newVal ? 1 : 2;
            device.thisFrameButtonValues.put(ouyaButton, flags |= device.thisFrameButtonValues.get(ouyaButton, 0));
        }
        device.buttonValues.put(ouyaButton, newVal);
        return true;
    }

    public static void startOfFrame() {
        for (OuyaController c : s_controllers) {
            if (c == null) continue;
            c.startOfFrameInternal();
        }
    }

    private void startOfFrameInternal() {
        if (this.thisFrameButtonValues.size() > 0) {
            this.thisFrameButtonValues.clear();
        }
    }

    public static void showCursor(boolean showCursor) {
        String ACTION_HIDE_CURSOR = "tv.ouya.controller.action.HIDE_CURSOR";
        String ACTION_SHOW_CURSOR = "tv.ouya.controller.action.SHOW_CURSOR";
        Intent intent = new Intent(showCursor ? "tv.ouya.controller.action.SHOW_CURSOR" : "tv.ouya.controller.action.HIDE_CURSOR");
        appContext.sendBroadcast(intent);
    }

    public static void setCursorBitmap(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        String ACTION_SET_CURSOR_BITMAP = "tv.ouya.controller.action.SET_CURSOR_BITMAP";
        String EXTRA_BITMAP = "CURSOR_BITMAP";
        String EXTRA_HOTSPOT_X = "HOTSPOT_X";
        String EXTRA_HOTSPOT_Y = "HOTSPOT_Y";
        Intent intent = new Intent("tv.ouya.controller.action.SET_CURSOR_BITMAP");
        if (bitmap != null) {
            intent.putExtra("CURSOR_BITMAP", (Parcelable)bitmap);
            intent.putExtra("HOTSPOT_X", hotSpotX);
            intent.putExtra("HOTSPOT_Y", hotSpotY);
        }
        appContext.sendBroadcast(intent);
    }

    public boolean buttonChangedThisFrame(int ouyaButton) {
        return this.thisFrameButtonValues.indexOfKey(ouyaButton) >= 0;
    }

    public boolean buttonPressedThisFrame(int ouyaButton) {
        return this.buttonChangedThisFrame(ouyaButton) && (this.thisFrameButtonValues.get(ouyaButton) & 1) != 0;
    }

    public boolean buttonReleasedThisFrame(int ouyaButton) {
        return this.buttonChangedThisFrame(ouyaButton) && (this.thisFrameButtonValues.get(ouyaButton) & 2) != 0;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public float getAxisValue(int ouyaAxis) {
        if (this.axisValues.indexOfKey(ouyaAxis) >= 0) {
            Float value = (Float)this.axisValues.get(ouyaAxis);
            return value.floatValue();
        }
        return 0.0f;
    }

    public boolean getButton(int ouyaButton) {
        if (this.buttonValues.indexOfKey(ouyaButton) >= 0) {
            boolean value = this.buttonValues.get(ouyaButton);
            return value;
        }
        return false;
    }

    public int getPlayerNum() {
        for (int i = 0; i < 4; ++i) {
            if (s_controllers[i] != this) continue;
            return i;
        }
        return -1;
    }

    private static OuyaController getOrCreateControllerByDeviceId(int deviceId) {
        OuyaController c = OuyaController.getControllerByDeviceId(deviceId);
        if (c != null) {
            return c;
        }
        int playerNum = OuyaController.getPlayerNumFromDeviceId(deviceId);
        if (playerNum < 0 || playerNum >= 4) {
            return null;
        }
        if (s_controllers[playerNum] != null) {
            Log.e((String)LOG_TAG, (String)("Controller for player " + playerNum + " already found, but doesn't match device id " + "(expected " + deviceId + " got " + s_controllers[playerNum].getDeviceId() + ")"));
            return s_controllers[playerNum];
        }
        OuyaController.s_controllers[playerNum] = new OuyaController(deviceId);
        return s_controllers[playerNum];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDeviceIdFromPlayerNum(int playerNum) {
        Cursor cursor = appContext.getContentResolver().query(sControllerUri, new String[]{"input_device_id"}, "player_num = ?", new String[]{String.valueOf(playerNum)}, null);
        try {
            if (cursor != null && cursor.moveToNext()) {
                int deviceId;
                int n = deviceId = cursor.getInt(0);
                return n;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPlayerNumFromDeviceId(int deviceId) {
        if (appContext == null) {
            return -1;
        }
        Cursor cursor = appContext.getContentResolver().query(sControllerUri, new String[]{"player_num"}, "input_device_id = ?", new String[]{String.valueOf(deviceId)}, null);
        try {
            if (cursor != null && cursor.moveToNext()) {
                int playerNum;
                int n = playerNum = cursor.getInt(0);
                return n;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBluetoothNameFromDeviceId(int deviceId) {
        if (appContext == null) {
            return null;
        }
        String btName = null;
        try {
            Cursor cursor = appContext.getContentResolver().query(sControllerUri, new String[]{"bt_name"}, "input_device_id = ?", new String[]{String.valueOf(deviceId)}, null);
            try {
                if (cursor != null && cursor.moveToNext()) {
                    btName = cursor.getString(0);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (SQLiteException e) {
        }
        catch (Exception e) {
            Log.d((String)LOG_TAG, (String)("Exception: " + e.getMessage()));
        }
        return btName;
    }

    OuyaController(int deviceId) {
        this.deviceId = deviceId;
        this.device = InputDevice.getDevice((int)deviceId);
        this.axisValues = new SparseArray();
        this.buttonValues = new SparseBooleanArray();
        this.thisFrameButtonValues = new SparseIntArray();
        this.deviceName = OuyaController.getBluetoothNameFromDeviceId(deviceId);
        if ((this.deviceName == null || this.deviceName.isEmpty()) && this.device != null) {
            this.deviceName = this.device.getName();
        }
    }

    static {
        sButtonDataBundle = null;
        sButtonDataCache = null;
        s_controllers = new OuyaController[4];
    }

    public static class ButtonData {
        public Drawable buttonDrawable;
        public String buttonName;

        ButtonData(Drawable buttonDrawable, String buttonName) {
            this.buttonDrawable = buttonDrawable;
            this.buttonName = buttonName;
        }
    }
}

