/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import tv.ouya.console.api.MappingParser;
import tv.ouya.console.api.OuyaController;

public class OuyaInputMapper {
    private static final String TAG = OuyaInputMapper.class.getSimpleName();
    private static final Uri sControllerUri = Uri.parse((String)"content://tv.ouya.controllerdata/");
    private static OuyaDeviceListener sDeviceListener = null;
    private static InputManager sInputManager;
    private static boolean sEnableControllerDispatch;
    private static SparseArray<MappingParser.Controller> sController;
    private static List<SparseBooleanArray> sLastValue;
    private static MappingParser sParser;
    private static boolean sSkipInputProcessing;

    public static void init(Activity activity) {
        int index;
        OuyaController.init((Context)activity);
        if (null == sDeviceListener) {
            sDeviceListener = new OuyaDeviceListener();
            sInputManager = (InputManager)activity.getSystemService("input");
            if (null != sInputManager) {
                sInputManager.registerInputDeviceListener((InputManager.InputDeviceListener)sDeviceListener, null);
            }
        }
        for (index = 0; index < 4; ++index) {
            sLastValue.add(new SparseBooleanArray());
        }
        for (index = 0; index < 4; ++index) {
            OuyaController controller = OuyaController.getControllerByPlayer(index);
            if (null == controller) continue;
            String name = "null";
            if (controller.getDevice() != null) {
                name = controller.getDevice().getName();
            }
            Log.i((String)TAG, (String)("OUYA Controller #" + index + ": " + name));
        }
        String json = OuyaInputMapper.getButtonRemappingJSONString(activity);
        sParser.parse(json);
    }

    public static void shutdown(Activity activity) {
        if (null != sInputManager) {
            sInputManager.unregisterInputDeviceListener((InputManager.InputDeviceListener)sDeviceListener);
        }
    }

    private static String getButtonRemappingJSONString(Activity activity) {
        Context context = activity.getApplicationContext();
        ContentResolver contentResolver = context.getContentResolver();
        Bundle result = null;
        try {
            result = contentResolver.call(sControllerUri, "get_button_remap_json", null, null);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Error querying button remapping");
        }
        return result != null ? result.getString("button_remap") : null;
    }

    public static void setEnableControllerDispatch(boolean enabled) {
        sEnableControllerDispatch = enabled;
    }

    private static MappingParser.Controller getControllerByDeviceId(int deviceId) {
        if (null != sController.get(deviceId)) {
            return (MappingParser.Controller)sController.get(deviceId);
        }
        sDeviceListener.onInputDeviceAdded(deviceId);
        return (MappingParser.Controller)sController.get(deviceId);
    }

    private static boolean passDispatchGenericMotionEvent(Activity activity, MotionEvent motionEvent) {
        if (sEnableControllerDispatch) {
            OuyaController.onGenericMotionEvent(motionEvent);
        }
        sSkipInputProcessing = true;
        boolean handled = activity.dispatchGenericMotionEvent(motionEvent);
        sSkipInputProcessing = false;
        return handled;
    }

    private static boolean passDispatchKeyEvent(Activity activity, KeyEvent keyEvent, boolean doFallbacks) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyEvent.getAction()) {
            case 0: {
                if (!sEnableControllerDispatch) break;
                OuyaController.onKeyDown(keyCode, keyEvent);
                break;
            }
            case 1: {
                if (!sEnableControllerDispatch) break;
                OuyaController.onKeyUp(keyCode, keyEvent);
            }
        }
        sSkipInputProcessing = true;
        boolean handled = activity.dispatchKeyEvent(keyEvent);
        if (!handled && doFallbacks) {
            int ouyaFallbackKeyCode = 0;
            switch (keyEvent.getKeyCode()) {
                case 96: {
                    ouyaFallbackKeyCode = 23;
                    break;
                }
                case 99: 
                case 100: {
                    handled = true;
                    break;
                }
                case 97: {
                    ouyaFallbackKeyCode = 4;
                }
            }
            if (ouyaFallbackKeyCode != 0) {
                KeyEvent fallbackKeyEvent = new KeyEvent(keyEvent.getDownTime(), keyEvent.getEventTime(), keyEvent.getAction(), ouyaFallbackKeyCode, keyEvent.getRepeatCount(), keyEvent.getMetaState(), keyEvent.getDeviceId(), 0, 1024);
                activity.dispatchKeyEvent(fallbackKeyEvent);
                handled = true;
            }
        }
        sSkipInputProcessing = false;
        return handled;
    }

    public static boolean shouldHandleInputEvent(InputEvent event) {
        return !sSkipInputProcessing;
    }

    public static boolean dispatchGenericMotionEvent(Activity activity, MotionEvent motionEvent) {
        int pointerCount;
        if (!OuyaInputMapper.shouldHandleInputEvent((InputEvent)motionEvent)) {
            throw new RuntimeException("Don't pass events when shouldHandleInputEvent is false");
        }
        View currentFocus = activity.getCurrentFocus();
        if (currentFocus != null && currentFocus instanceof EditText) {
            return OuyaInputMapper.passDispatchGenericMotionEvent(activity, motionEvent);
        }
        int playerNum = OuyaController.getPlayerNumByDeviceId(motionEvent.getDeviceId());
        if (playerNum < 0) {
            Log.e((String)TAG, (String)("Failed to find playerNum for Controller=" + motionEvent.getDevice().getName()));
            return OuyaInputMapper.passDispatchGenericMotionEvent(activity, motionEvent);
        }
        MappingParser.Controller controller = OuyaInputMapper.getControllerByDeviceId(motionEvent.getDeviceId());
        if (null == controller) {
            return OuyaInputMapper.passDispatchGenericMotionEvent(activity, motionEvent);
        }
        int source = motionEvent.getSource();
        boolean handled = false;
        Vector<MappingParser.ButtonIsAxis> buttons = controller.mButtonIsAxis;
        if (null != buttons) {
            for (int i = 0; i < buttons.size(); ++i) {
                KeyEvent keyEvent;
                int scancode;
                int deviceId;
                int metaState;
                int repeat;
                int code;
                int action;
                long eventTime;
                long downTime;
                MappingParser.ButtonIsAxis button = buttons.get(i);
                float axis = motionEvent.getAxisValue(button.mSourceAxis);
                if (axis >= button.mActionDownMin && axis <= button.mActionDownMax) {
                    if (sLastValue.get(playerNum).get(button.mDestinationKeyCode)) continue;
                    sLastValue.get(playerNum).put(button.mDestinationKeyCode, true);
                    downTime = 0L;
                    eventTime = 0L;
                    action = 0;
                    code = button.mDestinationKeyCode;
                    repeat = 0;
                    metaState = 0;
                    deviceId = motionEvent.getDeviceId();
                    scancode = 0;
                    keyEvent = new KeyEvent(downTime, eventTime, action, code, repeat, metaState, deviceId, scancode, 1024);
                    handled |= OuyaInputMapper.passDispatchKeyEvent(activity, keyEvent, true);
                    continue;
                }
                if (!sLastValue.get(playerNum).get(button.mDestinationKeyCode)) continue;
                sLastValue.get(playerNum).put(button.mDestinationKeyCode, false);
                downTime = 0L;
                eventTime = 0L;
                action = 1;
                code = button.mDestinationKeyCode;
                repeat = 0;
                metaState = 0;
                deviceId = motionEvent.getDeviceId();
                scancode = 0;
                keyEvent = new KeyEvent(downTime, eventTime, action, code, repeat, metaState, deviceId, scancode, 1024);
                handled |= OuyaInputMapper.passDispatchKeyEvent(activity, keyEvent, true);
            }
        }
        if (controller.mAxisExcludeSource.size() > 0 && controller.mAxisExcludeSource.get(source)) {
            return true;
        }
        Vector<MappingParser.AxisRemap> axises = controller.mAxisRemap;
        if (null != axises && (pointerCount = motionEvent.getPointerCount()) > 0 && axises.size() > 0) {
            MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
            MotionEvent.PointerCoords[] pointerCoords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
            motionEvent.getPointerProperties(0, pointerProperties[0]);
            motionEvent.getPointerCoords(0, pointerCoords[0]);
            for (int i = 0; i < axises.size(); ++i) {
                MappingParser.AxisRemap axis = axises.get(i);
                if (axis.mSourceAxis == axis.mDestinationAxis) continue;
                float val = motionEvent.getAxisValue(axis.mSourceAxis);
                pointerCoords[0].setAxisValue(axis.mDestinationAxis, val);
            }
            long downTime = motionEvent.getDownTime();
            long eventTime = motionEvent.getEventTime();
            int action = motionEvent.getAction();
            int metaState = motionEvent.getMetaState();
            int buttonState = motionEvent.getButtonState();
            float xPrecision = 1.0f;
            float yPrecision = 1.0f;
            int deviceId = motionEvent.getDeviceId();
            int edgeFlags = motionEvent.getEdgeFlags();
            int flags = motionEvent.getFlags();
            motionEvent = MotionEvent.obtain((long)downTime, (long)eventTime, (int)action, (int)pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)metaState, (int)buttonState, (float)xPrecision, (float)yPrecision, (int)deviceId, (int)edgeFlags, (int)source, (int)flags);
            motionEvent.recycle();
            return handled |= OuyaInputMapper.passDispatchGenericMotionEvent(activity, motionEvent);
        }
        return handled |= OuyaInputMapper.passDispatchGenericMotionEvent(activity, motionEvent);
    }

    public static boolean dispatchKeyEvent(Activity activity, KeyEvent keyEvent) {
        if (!OuyaInputMapper.shouldHandleInputEvent((InputEvent)keyEvent)) {
            throw new RuntimeException("Don't pass events when shouldHandleInputEvent is false");
        }
        View currentFocus = activity.getCurrentFocus();
        if (currentFocus != null && currentFocus instanceof EditText) {
            return OuyaInputMapper.passDispatchKeyEvent(activity, keyEvent, false);
        }
        MappingParser.Controller controller = OuyaInputMapper.getControllerByDeviceId(keyEvent.getDeviceId());
        if (null == controller) {
            return OuyaInputMapper.passDispatchKeyEvent(activity, keyEvent, true);
        }
        int keyCode = keyEvent.getKeyCode();
        int source = keyEvent.getSource();
        MappingParser.Button button = sParser.getButton(controller, keyCode);
        if (null == button) {
            return OuyaInputMapper.passDispatchKeyEvent(activity, keyEvent, true);
        }
        if (button.mExcludeSource.size() > 0 && button.mExcludeSource.get(source)) {
            return true;
        }
        KeyEvent newKeyEvent = null;
        if (keyCode == button.mDestinationKeyCode) {
            newKeyEvent = keyEvent;
        } else {
            long downTime = keyEvent.getDownTime();
            long eventTime = keyEvent.getEventTime();
            int action = keyEvent.getAction();
            int code = button.mDestinationKeyCode;
            int repeat = keyEvent.getRepeatCount();
            int metaState = keyEvent.getMetaState();
            int deviceId = keyEvent.getDeviceId();
            int scancode = 0;
            newKeyEvent = new KeyEvent(downTime, eventTime, action, code, repeat, metaState, deviceId, scancode);
        }
        return OuyaInputMapper.passDispatchKeyEvent(activity, newKeyEvent, true);
    }

    static {
        sEnableControllerDispatch = true;
        sController = new SparseArray();
        sLastValue = new ArrayList<SparseBooleanArray>();
        sParser = new MappingParser();
        sSkipInputProcessing = false;
    }

    static class OuyaDeviceListener
    implements InputManager.InputDeviceListener {
        OuyaDeviceListener() {
        }

        public void onInputDeviceAdded(int deviceId) {
            if (null == sController.get(deviceId)) {
                OuyaController ouyaController = OuyaController.getControllerByDeviceId(deviceId);
                if (null != ouyaController) {
                    MappingParser.Controller controller = sParser.getController(sParser.getIdByString(ouyaController.getDeviceName()));
                    if (null != controller) {
                        sController.put(deviceId, (Object)controller);
                    }
                } else {
                    Log.e((String)TAG, (String)("onInputDeviceAdded device=" + deviceId + " not found"));
                }
            }
        }

        public void onInputDeviceChanged(int deviceId) {
        }

        public void onInputDeviceRemoved(int deviceId) {
            if (null != sController.get(deviceId)) {
                sController.remove(deviceId);
            }
        }
    }
}

