/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api.store;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tv.ouya.console.api.Product;
import tv.ouya.console.api.store.AppDescription;

public final class AppDetails
implements Parcelable {
    public static final Parcelable.Creator<AppDetails> CREATOR = new Parcelable.Creator<AppDetails>(){

        public AppDetails createFromParcel(Parcel parcel) {
            String title = parcel.readString();
            String description = parcel.readString();
            String mainImageFullUrl = parcel.readString();
            String uuid = parcel.readString();
            Long apkFileSize = parcel.readLong();
            String versionNumber = parcel.readString();
            String publishedAt = parcel.readString();
            ArrayList<String> imageUrls = new ArrayList<String>();
            parcel.readStringList(imageUrls);
            Long likeCount = parcel.readLong();
            String overview = parcel.readString();
            String contentRating = parcel.readString();
            String versionUuid = parcel.readString();
            Boolean founder = parcel.readByte() == 1;
            String developer = parcel.readString();
            Boolean premium = parcel.readByte() == 1;
            Boolean inAppPurchases = parcel.readByte() == 1;
            String videoUrl = parcel.readString();
            boolean hasPrimaryProduct = parcel.readInt() == 1;
            Product primaryProduct = null;
            if (hasPrimaryProduct) {
                primaryProduct = (Product)Product.CREATOR.createFromParcel(parcel);
            }
            double rating = parcel.readDouble();
            int ratingCount = parcel.readInt();
            return new AppDetails(title, description, mainImageFullUrl, uuid, apkFileSize, versionNumber, publishedAt, imageUrls, likeCount, overview, contentRating, versionUuid, founder, developer, premium, inAppPurchases, videoUrl, primaryProduct, rating, ratingCount);
        }

        public AppDetails[] newArray(int size) {
            return new AppDetails[size];
        }
    };
    public String title;
    public String description;
    public String mainImageFullUrl;
    public String uuid;
    public Long apkFileSize;
    public String versionNumber;
    public String publishedAt;
    public List<String> imageUrls;
    public Long likeCount;
    public String overview;
    public String contentRating;
    public String latestVersion;
    public boolean founder;
    public String developer;
    public boolean premium;
    public boolean inAppPurchases;
    public String videoUrl;
    public Product primaryProduct;
    public double rating;
    public int ratingCount;

    public AppDetails() {
        this.imageUrls = new ArrayList<String>();
    }

    public AppDetails(JSONObject object) throws JSONException {
        this.readFromJSON(object);
    }

    public AppDetails(String title, String description, String mainImageFullUrl, String uuid, Long apkFileSize, String versionNumber, String publishedAt, List<String> imageUrls, Long likeCount, String overview, String contentRating, String latestVersion, Boolean founder, String developer, Boolean premium, Boolean inAppPurchases, String videoUrl, Product primaryProduct, double rating, int ratingCount) {
        this.title = title;
        this.description = description;
        this.mainImageFullUrl = mainImageFullUrl;
        this.uuid = uuid;
        this.apkFileSize = apkFileSize;
        this.versionNumber = versionNumber;
        this.publishedAt = publishedAt;
        this.imageUrls = imageUrls;
        this.likeCount = likeCount;
        this.overview = overview;
        this.contentRating = contentRating;
        this.latestVersion = latestVersion;
        this.founder = founder;
        this.developer = developer;
        this.premium = premium;
        this.inAppPurchases = inAppPurchases;
        this.videoUrl = videoUrl;
        this.primaryProduct = primaryProduct;
        this.rating = rating;
        this.ratingCount = ratingCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppDetails)) {
            return false;
        }
        AppDetails that = (AppDetails)o;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.mainImageFullUrl.equals(that.mainImageFullUrl)) {
            return false;
        }
        if (!this.title.equals(that.title)) {
            return false;
        }
        if (!this.uuid.equals(that.uuid)) {
            return false;
        }
        if (!this.apkFileSize.equals(that.apkFileSize)) {
            return false;
        }
        if (!this.versionNumber.equals(that.versionNumber)) {
            return false;
        }
        if (!this.publishedAt.equals(that.publishedAt)) {
            return false;
        }
        if (!this.likeCount.equals(that.likeCount)) {
            return false;
        }
        if (!this.overview.equals(that.overview)) {
            return false;
        }
        if (!this.contentRating.equals(that.contentRating)) {
            return false;
        }
        if (!this.latestVersion.equals(that.latestVersion)) {
            return false;
        }
        if (this.founder != that.founder) {
            return false;
        }
        if (!this.developer.equals(that.developer)) {
            return false;
        }
        if (this.premium != that.premium) {
            return false;
        }
        if (this.inAppPurchases != that.inAppPurchases) {
            return false;
        }
        if (this.videoUrl == null ? that.videoUrl != null : !this.videoUrl.equals(that.videoUrl)) {
            return false;
        }
        if (this.primaryProduct == null ? that.primaryProduct != null : !this.primaryProduct.equals(that.primaryProduct)) {
            return false;
        }
        if (this.rating != that.rating) {
            return false;
        }
        return this.ratingCount == that.ratingCount;
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.mainImageFullUrl.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.title);
        parcel.writeString(this.description);
        parcel.writeString(this.mainImageFullUrl);
        parcel.writeString(this.uuid);
        parcel.writeLong(this.apkFileSize.longValue());
        parcel.writeString(this.versionNumber);
        parcel.writeString(this.publishedAt);
        parcel.writeStringList(this.imageUrls);
        parcel.writeLong(this.likeCount.longValue());
        parcel.writeString(this.overview);
        parcel.writeString(this.contentRating);
        parcel.writeString(this.latestVersion);
        parcel.writeByte(this.founder ? (byte)1 : 0);
        parcel.writeString(this.developer);
        parcel.writeByte(this.premium ? (byte)1 : 0);
        parcel.writeByte(this.inAppPurchases ? (byte)1 : 0);
        parcel.writeString(this.videoUrl);
        parcel.writeInt(this.primaryProduct != null ? 1 : 0);
        if (this.primaryProduct != null) {
            this.primaryProduct.writeToParcel(parcel, i);
        }
        parcel.writeDouble(this.rating);
        parcel.writeInt(this.ratingCount);
    }

    public void readFromJSON(JSONObject object) throws JSONException {
        JSONObject productJSON;
        this.title = object.optString("title");
        this.description = object.optString("description");
        this.mainImageFullUrl = object.optString("mainImageFullUrl");
        this.uuid = object.optString("uuid");
        this.apkFileSize = object.optLong("apkFileSize");
        this.versionNumber = object.optString("versionNumber");
        this.publishedAt = object.optString("publishedAt");
        this.contentRating = object.optString("contentRating");
        this.latestVersion = object.optString("latestVersion");
        this.imageUrls = new ArrayList<String>();
        JSONArray a = object.optJSONArray("filepickerScreenshots");
        if (a == null || a.length() == 0) {
            a = object.optJSONArray("screenshots");
        }
        if (a != null) {
            for (int i = 0; i < a.length(); ++i) {
                this.imageUrls.add(a.getString(i));
            }
        }
        this.likeCount = object.optLong("likeCount");
        this.overview = object.optString("overview");
        this.founder = object.optBoolean("founder");
        this.developer = object.optString("developer");
        this.premium = object.optBoolean("premium");
        this.inAppPurchases = object.optBoolean("inAppPurchases");
        this.videoUrl = object.optString("videoUrl");
        if (this.videoUrl.equals("null")) {
            this.videoUrl = null;
        }
        if ((productJSON = object.optJSONObject("primaryProduct")) != null) {
            this.primaryProduct = new Product();
            this.primaryProduct.readFromJSONObject(productJSON);
        }
        this.rating = object.optDouble("ratingAverage", 0.0);
        this.ratingCount = object.optInt("ratingCount", 0);
    }

    public AppDescription getDescription(String appUuid) {
        AppDescription.AppVersion version = new AppDescription.AppVersion();
        version.setMainImageFullUrl(this.mainImageFullUrl);
        version.setUploadedAt(this.publishedAt);
        version.setUuid(this.uuid);
        version.setContentRating(this.contentRating);
        HashMap<String, AppDescription.AppVersion> versions = new HashMap<String, AppDescription.AppVersion>();
        versions.put("published", version);
        return new AppDescription(appUuid, this.title, this.mainImageFullUrl, this.primaryProduct, versions, this.rating, this.ratingCount, this.premium, this.inAppPurchases, null);
    }
}

