/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.internal;

import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import tv.ouya.console.api.GamerInfo;
import tv.ouya.console.api.OuyaResponseListener;
import tv.ouya.console.internal.IStringListener;
import tv.ouya.console.internal.ListenerBinderHelper;

public class GamerInfoListenerBinder
extends IStringListener.Stub {
    private static final String LOG_TAG = "GamerInfoListenerBinder";
    private ListenerBinderHelper<GamerInfo> binderHelper;

    public GamerInfoListenerBinder(OuyaResponseListener<GamerInfo> binderHelper) {
        this.binderHelper = new ListenerBinderHelper<GamerInfo>(binderHelper);
    }

    @Override
    public void onSuccess(String result) throws RemoteException {
        try {
            JSONObject gamerInfoJson = new JSONObject(result);
            JSONObject gamerObject = gamerInfoJson.getJSONObject("gamer");
            String uuid = gamerObject.optString("uuid", "");
            String username = gamerObject.optString("username", "");
            GamerInfo gamerInfo = new GamerInfo(uuid, username);
            this.binderHelper.onSuccess(gamerInfo);
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)("Exception parsing result: " + (Object)((Object)e)));
        }
    }

    @Override
    public void onFailure(int errorCode, String errorMessage, Bundle optionalData) throws RemoteException {
        this.binderHelper.onFailure(errorCode, errorMessage, optionalData);
    }

    @Override
    public void onCancel() throws RemoteException {
        this.binderHelper.onCancel();
    }
}

