/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oauth.signpost.http.HttpRequest;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.client.HttpExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestAdapter
implements HttpRequest {
    private HttpExchange request;
    private String requestUrl;

    public HttpRequestAdapter(HttpExchange request) {
        this.request = request;
        this.buildRequestUrl();
    }

    public String getContentType() {
        HttpFields fields = this.request.getRequestFields();
        return fields.getStringField("Content-Type");
    }

    public InputStream getMessagePayload() throws IOException {
        return new ByteArrayInputStream(this.request.getRequestContent().array());
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String url) {
        throw new RuntimeException(new UnsupportedOperationException());
    }

    public void setHeader(String name, String value) {
        this.request.setRequestHeader(name, value);
    }

    public String getHeader(String name) {
        HttpFields fields = this.request.getRequestFields();
        return fields.getStringField(name);
    }

    public Map<String, String> getAllHeaders() {
        HttpFields fields = this.request.getRequestFields();
        Iterator iter = fields.getFields();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (iter.hasNext()) {
            HttpFields.Field field = (HttpFields.Field)iter.next();
            headers.put(field.getName(), field.getValue());
        }
        return headers;
    }

    private void buildRequestUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.request.getScheme() + "://");
        sb.append(this.request.getAddress().toString().replaceAll(":\\d+", ""));
        if (this.request.getURI() != null) {
            sb.append(this.request.getURI());
        }
        this.requestUrl = sb.toString();
    }

    public Object unwrap() {
        return this.request;
    }
}

