/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.file;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.file.Codec;
import com.flurry.org.apache.avro.file.DeflateCodec;
import com.flurry.org.apache.avro.file.NullCodec;
import com.flurry.org.apache.avro.file.SnappyCodec;
import java.util.HashMap;
import java.util.Map;

public abstract class CodecFactory {
    private static final Map<String, CodecFactory> REGISTERED = new HashMap<String, CodecFactory>();
    private static final int DEFAULT_DEFLATE_LEVEL = -1;

    public static CodecFactory nullCodec() {
        return NullCodec.OPTION;
    }

    public static CodecFactory deflateCodec(int compressionLevel) {
        return new DeflateCodec.Option(compressionLevel);
    }

    public static CodecFactory snappyCodec() {
        return new SnappyCodec.Option();
    }

    protected abstract Codec createInstance();

    public static CodecFactory fromString(String s2) {
        CodecFactory o2 = REGISTERED.get(s2);
        if (o2 == null) {
            throw new AvroRuntimeException("Unrecognized codec: " + s2);
        }
        return o2;
    }

    public static CodecFactory addCodec(String name, CodecFactory c2) {
        return REGISTERED.put(name, c2);
    }

    public String toString() {
        Codec instance = this.createInstance();
        return instance.toString();
    }

    static {
        CodecFactory.addCodec("null", CodecFactory.nullCodec());
        CodecFactory.addCodec("deflate", CodecFactory.deflateCodec(-1));
        CodecFactory.addCodec("snappy", CodecFactory.snappyCodec());
    }
}

