/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.BinaryData;
import com.flurry.org.apache.avro.io.BufferedBinaryEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BlockingBinaryEncoder
extends BufferedBinaryEncoder {
    private byte[] buf;
    private int pos;
    private BlockedValue[] blockStack;
    private int stackTop = -1;
    private static final int STACK_STEP = 10;
    private byte[] headerBuffer = new byte[12];

    private boolean check() {
        assert (this.buf != null);
        assert (0 <= this.pos);
        assert (this.pos <= this.buf.length) : this.pos + " " + this.buf.length;
        assert (this.blockStack != null);
        BlockedValue prev = null;
        for (int i2 = 0; i2 <= this.stackTop; ++i2) {
            BlockedValue v2 = this.blockStack[i2];
            v2.check(prev, this.pos);
            prev = v2;
        }
        return true;
    }

    BlockingBinaryEncoder(OutputStream out, int blockBufferSize, int binaryEncoderBufferSize) {
        super(out, binaryEncoderBufferSize);
        this.buf = new byte[blockBufferSize];
        this.pos = 0;
        this.blockStack = new BlockedValue[0];
        this.expandStack();
        BlockedValue bv2 = this.blockStack[++this.stackTop];
        bv2.type = null;
        bv2.state = BlockedValue.State.ROOT;
        bv2.lastFullItem = 0;
        bv2.start = 0;
        bv2.items = 1;
        assert (this.check());
    }

    private void expandStack() {
        int oldLength = this.blockStack.length;
        this.blockStack = Arrays.copyOf(this.blockStack, this.blockStack.length + 10);
        for (int i2 = oldLength; i2 < this.blockStack.length; ++i2) {
            this.blockStack[i2] = new BlockedValue();
        }
    }

    BlockingBinaryEncoder configure(OutputStream out, int blockBufferSize, int binaryEncoderBufferSize) {
        super.configure(out, binaryEncoderBufferSize);
        this.pos = 0;
        this.stackTop = 0;
        if (null == this.buf || this.buf.length != blockBufferSize) {
            this.buf = new byte[blockBufferSize];
        }
        assert (this.check());
        return this;
    }

    @Override
    public void flush() throws IOException {
        BlockedValue bv2 = this.blockStack[this.stackTop];
        if (bv2.state == BlockedValue.State.ROOT) {
            super.writeFixed(this.buf, 0, this.pos);
            this.pos = 0;
        } else {
            while (bv2.state != BlockedValue.State.OVERFLOW) {
                this.compact();
            }
        }
        super.flush();
        assert (this.check());
    }

    @Override
    public void writeBoolean(boolean b2) throws IOException {
        this.ensureBounds(1);
        this.pos += BinaryData.encodeBoolean(b2, this.buf, this.pos);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.ensureBounds(5);
        this.pos += BinaryData.encodeInt(n2, this.buf, this.pos);
    }

    @Override
    public void writeLong(long n2) throws IOException {
        this.ensureBounds(10);
        this.pos += BinaryData.encodeLong(n2, this.buf, this.pos);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.ensureBounds(4);
        this.pos += BinaryData.encodeFloat(f2, this.buf, this.pos);
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.ensureBounds(8);
        this.pos += BinaryData.encodeDouble(d2, this.buf, this.pos);
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.doWriteBytes(bytes, start, len);
    }

    @Override
    protected void writeZero() throws IOException {
        this.ensureBounds(1);
        this.buf[this.pos++] = 0;
    }

    @Override
    public void writeArrayStart() throws IOException {
        if (this.stackTop + 1 == this.blockStack.length) {
            this.expandStack();
        }
        BlockedValue bv2 = this.blockStack[++this.stackTop];
        bv2.type = Schema.Type.ARRAY;
        bv2.state = BlockedValue.State.REGULAR;
        bv2.start = bv2.lastFullItem = this.pos;
        bv2.items = 0;
        assert (this.check());
    }

    @Override
    public void setItemCount(long itemCount) throws IOException {
        BlockedValue v2 = this.blockStack[this.stackTop];
        assert (v2.type == Schema.Type.ARRAY || v2.type == Schema.Type.MAP);
        assert (v2.itemsLeftToWrite == 0L);
        v2.itemsLeftToWrite = itemCount;
        assert (this.check());
    }

    @Override
    public void startItem() throws IOException {
        if (this.blockStack[this.stackTop].state == BlockedValue.State.OVERFLOW) {
            this.finishOverflow();
        }
        BlockedValue t2 = this.blockStack[this.stackTop];
        ++t2.items;
        t2.lastFullItem = this.pos;
        --t2.itemsLeftToWrite;
        assert (this.check());
    }

    @Override
    public void writeArrayEnd() throws IOException {
        BlockedValue top = this.blockStack[this.stackTop];
        if (top.type != Schema.Type.ARRAY) {
            throw new AvroTypeException("Called writeArrayEnd outside of an array.");
        }
        if (top.itemsLeftToWrite != 0L) {
            throw new AvroTypeException("Failed to write expected number of array elements.");
        }
        this.endBlockedValue();
        assert (this.check());
    }

    @Override
    public void writeMapStart() throws IOException {
        if (this.stackTop + 1 == this.blockStack.length) {
            this.expandStack();
        }
        BlockedValue bv2 = this.blockStack[++this.stackTop];
        bv2.type = Schema.Type.MAP;
        bv2.state = BlockedValue.State.REGULAR;
        bv2.start = bv2.lastFullItem = this.pos;
        bv2.items = 0;
        assert (this.check());
    }

    @Override
    public void writeMapEnd() throws IOException {
        BlockedValue top = this.blockStack[this.stackTop];
        if (top.type != Schema.Type.MAP) {
            throw new AvroTypeException("Called writeMapEnd outside of a map.");
        }
        if (top.itemsLeftToWrite != 0L) {
            throw new AvroTypeException("Failed to read write expected number of array elements.");
        }
        this.endBlockedValue();
        assert (this.check());
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        this.ensureBounds(5);
        this.pos += BinaryData.encodeInt(unionIndex, this.buf, this.pos);
    }

    @Override
    public int bytesBuffered() {
        return this.pos + super.bytesBuffered();
    }

    private void endBlockedValue() throws IOException {
        while (true) {
            assert (this.check());
            BlockedValue t2 = this.blockStack[this.stackTop];
            assert (t2.state != BlockedValue.State.ROOT);
            if (t2.state == BlockedValue.State.OVERFLOW) {
                this.finishOverflow();
            }
            assert (t2.state == BlockedValue.State.REGULAR);
            if (0 >= t2.items) break;
            int byteCount = this.pos - t2.start;
            if (t2.start == 0 && this.blockStack[this.stackTop - 1].state != BlockedValue.State.REGULAR) {
                super.writeInt(-t2.items);
                super.writeInt(byteCount);
                break;
            }
            int headerSize = 0;
            headerSize += BinaryData.encodeInt(-t2.items, this.headerBuffer, headerSize);
            if (this.buf.length >= this.pos + (headerSize += BinaryData.encodeInt(byteCount, this.headerBuffer, headerSize))) {
                this.pos += headerSize;
                int m2 = t2.start;
                System.arraycopy(this.buf, m2, this.buf, m2 + headerSize, byteCount);
                System.arraycopy(this.headerBuffer, 0, this.buf, m2, headerSize);
                break;
            }
            this.compact();
        }
        --this.stackTop;
        this.ensureBounds(1);
        this.buf[this.pos++] = 0;
        assert (this.check());
        if (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT) {
            this.flush();
        }
    }

    private void finishOverflow() throws IOException {
        BlockedValue s2 = this.blockStack[this.stackTop];
        if (s2.state != BlockedValue.State.OVERFLOW) {
            throw new IllegalStateException("Not an overflow block");
        }
        assert (this.check());
        super.writeFixed(this.buf, 0, this.pos);
        this.pos = 0;
        s2.state = BlockedValue.State.REGULAR;
        s2.lastFullItem = 0;
        s2.start = 0;
        s2.items = 0;
        assert (this.check());
    }

    private void ensureBounds(int l2) throws IOException {
        while (this.buf.length < this.pos + l2) {
            if (this.blockStack[this.stackTop].state == BlockedValue.State.REGULAR) {
                this.compact();
                continue;
            }
            super.writeFixed(this.buf, 0, this.pos);
            this.pos = 0;
        }
    }

    private void doWriteBytes(byte[] bytes, int start, int len) throws IOException {
        if (len < this.buf.length) {
            this.ensureBounds(len);
            System.arraycopy(bytes, start, this.buf, this.pos, len);
            this.pos += len;
        } else {
            this.ensureBounds(this.buf.length);
            assert (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT || this.blockStack[this.stackTop].state == BlockedValue.State.OVERFLOW);
            this.write(bytes, start, len);
        }
    }

    private void write(byte[] b2, int off, int len) throws IOException {
        if (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT) {
            super.writeFixed(b2, off, len);
        } else {
            assert (this.check());
            while (this.buf.length < this.pos + len) {
                if (this.blockStack[this.stackTop].state == BlockedValue.State.REGULAR) {
                    this.compact();
                    continue;
                }
                super.writeFixed(this.buf, 0, this.pos);
                this.pos = 0;
                if (this.buf.length > len) continue;
                super.writeFixed(b2, off, len);
                len = 0;
            }
            System.arraycopy(b2, off, this.buf, this.pos, len);
            this.pos += len;
        }
        assert (this.check());
    }

    private void compact() throws IOException {
        int i2;
        assert (this.check());
        BlockedValue s2 = null;
        for (i2 = 1; i2 <= this.stackTop; ++i2) {
            s2 = this.blockStack[i2];
            if (s2.state == BlockedValue.State.REGULAR) break;
        }
        assert (s2 != null);
        super.writeFixed(this.buf, 0, s2.start);
        if (1 < s2.items) {
            super.writeInt(-(s2.items - 1));
            super.writeInt(s2.lastFullItem - s2.start);
            super.writeFixed(this.buf, s2.start, s2.lastFullItem - s2.start);
            s2.start = s2.lastFullItem;
            s2.items = 1;
        }
        super.writeInt(1);
        BlockedValue n2 = i2 + 1 <= this.stackTop ? this.blockStack[i2 + 1] : null;
        int end = n2 == null ? this.pos : n2.start;
        super.writeFixed(this.buf, s2.lastFullItem, end - s2.lastFullItem);
        System.arraycopy(this.buf, end, this.buf, 0, this.pos - end);
        for (int j2 = i2 + 1; j2 <= this.stackTop; ++j2) {
            n2 = this.blockStack[j2];
            n2.start -= end;
            n2.lastFullItem -= end;
        }
        this.pos -= end;
        assert (s2.items == 1);
        s2.lastFullItem = 0;
        s2.start = 0;
        s2.state = BlockedValue.State.OVERFLOW;
        assert (this.check());
    }

    private static class BlockedValue {
        public Schema.Type type = null;
        public State state = State.ROOT;
        public int start = 0;
        public int lastFullItem = 0;
        public int items = 1;
        public long itemsLeftToWrite;

        public boolean check(BlockedValue prev, int pos) {
            assert (this.state != State.ROOT || this.type == null);
            assert (this.state == State.ROOT || this.type == Schema.Type.ARRAY || this.type == Schema.Type.MAP);
            assert (0 <= this.items);
            assert (0 != this.items || this.start == pos);
            assert (1 < this.items || this.start == this.lastFullItem);
            assert (this.items <= 1 || this.start <= this.lastFullItem);
            assert (this.lastFullItem <= pos);
            switch (this.state) {
                case ROOT: {
                    assert (this.start == 0);
                    assert (prev == null);
                    break;
                }
                case REGULAR: {
                    assert (this.start >= 0);
                    assert (prev.lastFullItem <= this.start);
                    assert (1 <= prev.items);
                    break;
                }
                case OVERFLOW: {
                    assert (this.start == 0);
                    assert (this.items == 1);
                    assert (prev.state == State.ROOT || prev.state == State.OVERFLOW);
                    break;
                }
            }
            return false;
        }

        public static enum State {
            ROOT,
            REGULAR,
            OVERFLOW;

        }
    }
}

