/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.io.BinaryData;
import com.flurry.org.apache.avro.io.BinaryEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedBinaryEncoder
extends BinaryEncoder {
    private byte[] buf;
    private int pos;
    private ByteSink sink;
    private int bulkLimit;

    BufferedBinaryEncoder(OutputStream out, int bufferSize) {
        this.configure(out, bufferSize);
    }

    BufferedBinaryEncoder configure(OutputStream out, int bufferSize) {
        if (null == out) {
            throw new NullPointerException("OutputStream cannot be null!");
        }
        if (null != this.sink && this.pos > 0) {
            try {
                this.flushBuffer();
            }
            catch (IOException e2) {
                throw new AvroRuntimeException("Failure flushing old output", e2);
            }
        }
        this.sink = new OutputStreamSink(out);
        this.pos = 0;
        if (null == this.buf || this.buf.length != bufferSize) {
            this.buf = new byte[bufferSize];
        }
        this.bulkLimit = this.buf.length >>> 1;
        if (this.bulkLimit > 512) {
            this.bulkLimit = 512;
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.sink.innerFlush();
    }

    private void flushBuffer() throws IOException {
        if (this.pos > 0) {
            this.sink.innerWrite(this.buf, 0, this.pos);
            this.pos = 0;
        }
    }

    private void ensureBounds(int num) throws IOException {
        int remaining = this.buf.length - this.pos;
        if (remaining < num) {
            this.flushBuffer();
        }
    }

    @Override
    public void writeBoolean(boolean b2) throws IOException {
        if (this.buf.length == this.pos) {
            this.flushBuffer();
        }
        this.pos += BinaryData.encodeBoolean(b2, this.buf, this.pos);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.ensureBounds(5);
        this.pos += BinaryData.encodeInt(n2, this.buf, this.pos);
    }

    @Override
    public void writeLong(long n2) throws IOException {
        this.ensureBounds(10);
        this.pos += BinaryData.encodeLong(n2, this.buf, this.pos);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.ensureBounds(4);
        this.pos += BinaryData.encodeFloat(f2, this.buf, this.pos);
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.ensureBounds(8);
        this.pos += BinaryData.encodeDouble(d2, this.buf, this.pos);
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        if (len > this.bulkLimit) {
            this.flushBuffer();
            this.sink.innerWrite(bytes, start, len);
            return;
        }
        this.ensureBounds(len);
        System.arraycopy(bytes, start, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    protected void writeZero() throws IOException {
        this.writeByte(0);
    }

    private void writeByte(int b2) throws IOException {
        if (this.pos == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.pos++] = (byte)(b2 & 0xFF);
    }

    @Override
    public int bytesBuffered() {
        return this.pos;
    }

    static class OutputStreamSink
    extends ByteSink {
        private final OutputStream out;

        private OutputStreamSink(OutputStream out) {
            this.out = out;
        }

        @Override
        protected void innerWrite(byte[] bytes, int off, int len) throws IOException {
            this.out.write(bytes, off, len);
        }

        @Override
        protected void innerFlush() throws IOException {
            this.out.flush();
        }
    }

    private static abstract class ByteSink {
        protected ByteSink() {
        }

        protected abstract void innerWrite(byte[] var1, int var2, int var3) throws IOException;

        protected abstract void innerFlush() throws IOException;
    }
}

