/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.ParsingEncoder;
import com.flurry.org.apache.avro.io.parsing.JsonGrammarGenerator;
import com.flurry.org.apache.avro.io.parsing.Parser;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import com.flurry.org.apache.avro.util.Utf8;
import com.flurry.org.codehaus.jackson.JsonEncoding;
import com.flurry.org.codehaus.jackson.JsonFactory;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class JsonEncoder
extends ParsingEncoder
implements Parser.ActionHandler {
    final Parser parser;
    private JsonGenerator out;
    protected BitSet isEmpty = new BitSet();

    JsonEncoder(Schema sc, OutputStream out) throws IOException {
        this(sc, JsonEncoder.getJsonGenerator(out));
    }

    JsonEncoder(Schema sc, JsonGenerator out) throws IOException {
        this.configure(out);
        this.parser = new Parser(new JsonGrammarGenerator().generate(sc), this);
    }

    @Override
    public void flush() throws IOException {
        this.parser.processImplicitActions();
        if (this.out != null) {
            this.out.flush();
        }
    }

    private static JsonGenerator getJsonGenerator(OutputStream out) throws IOException {
        if (null == out) {
            throw new NullPointerException("OutputStream cannot be null");
        }
        JsonGenerator g2 = new JsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
        MinimalPrettyPrinter pp = new MinimalPrettyPrinter();
        pp.setRootValueSeparator(System.getProperty("line.separator"));
        g2.setPrettyPrinter(pp);
        return g2;
    }

    public JsonEncoder configure(OutputStream out) throws IOException {
        this.configure(JsonEncoder.getJsonGenerator(out));
        return this;
    }

    public JsonEncoder configure(JsonGenerator generator) throws IOException {
        if (null == generator) {
            throw new NullPointerException("JsonGenerator cannot be null");
        }
        if (null != this.parser) {
            this.flush();
        }
        this.out = generator;
        return this;
    }

    @Override
    public void writeNull() throws IOException {
        this.parser.advance(Symbol.NULL);
        this.out.writeNull();
    }

    @Override
    public void writeBoolean(boolean b2) throws IOException {
        this.parser.advance(Symbol.BOOLEAN);
        this.out.writeBoolean(b2);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.parser.advance(Symbol.INT);
        this.out.writeNumber(n2);
    }

    @Override
    public void writeLong(long n2) throws IOException {
        this.parser.advance(Symbol.LONG);
        this.out.writeNumber(n2);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.parser.advance(Symbol.FLOAT);
        this.out.writeNumber(f2);
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.parser.advance(Symbol.DOUBLE);
        this.out.writeNumber(d2);
    }

    @Override
    public void writeString(Utf8 utf8) throws IOException {
        this.writeString(utf8.toString());
    }

    @Override
    public void writeString(String str) throws IOException {
        this.parser.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            this.out.writeFieldName(str);
        } else {
            this.out.writeString(str);
        }
    }

    @Override
    public void writeBytes(ByteBuffer bytes) throws IOException {
        if (bytes.hasArray()) {
            this.writeBytes(bytes.array(), bytes.position(), bytes.remaining());
        } else {
            byte[] b2 = new byte[bytes.remaining()];
            for (int i2 = 0; i2 < b2.length; ++i2) {
                b2[i2] = bytes.get();
            }
            this.writeBytes(b2);
        }
    }

    @Override
    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        this.parser.advance(Symbol.BYTES);
        this.writeByteArray(bytes, start, len);
    }

    private void writeByteArray(byte[] bytes, int start, int len) throws IOException {
        this.out.writeString(new String(bytes, start, len, "ISO-8859-1"));
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.parser.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        if (len != top.size) {
            throw new AvroTypeException("Incorrect length for fixed binary: expected " + top.size + " but received " + len + " bytes.");
        }
        this.writeByteArray(bytes, start, len);
    }

    @Override
    public void writeEnum(int e2) throws IOException {
        this.parser.advance(Symbol.ENUM);
        Symbol.EnumLabelsAction top = (Symbol.EnumLabelsAction)this.parser.popSymbol();
        if (e2 < 0 || e2 >= top.size) {
            throw new AvroTypeException("Enumeration out of range: max is " + top.size + " but received " + e2);
        }
        this.out.writeString(top.getLabel(e2));
    }

    @Override
    public void writeArrayStart() throws IOException {
        this.parser.advance(Symbol.ARRAY_START);
        this.out.writeStartArray();
        this.push();
        this.isEmpty.set(this.depth());
    }

    @Override
    public void writeArrayEnd() throws IOException {
        if (!this.isEmpty.get(this.pos)) {
            this.parser.advance(Symbol.ITEM_END);
        }
        this.pop();
        this.parser.advance(Symbol.ARRAY_END);
        this.out.writeEndArray();
    }

    @Override
    public void writeMapStart() throws IOException {
        this.push();
        this.isEmpty.set(this.depth());
        this.parser.advance(Symbol.MAP_START);
        this.out.writeStartObject();
    }

    @Override
    public void writeMapEnd() throws IOException {
        if (!this.isEmpty.get(this.pos)) {
            this.parser.advance(Symbol.ITEM_END);
        }
        this.pop();
        this.parser.advance(Symbol.MAP_END);
        this.out.writeEndObject();
    }

    @Override
    public void startItem() throws IOException {
        if (!this.isEmpty.get(this.pos)) {
            this.parser.advance(Symbol.ITEM_END);
        }
        super.startItem();
        this.isEmpty.clear(this.depth());
    }

    @Override
    public void writeIndex(int unionIndex) throws IOException {
        this.parser.advance(Symbol.UNION);
        Symbol.Alternative top = (Symbol.Alternative)this.parser.popSymbol();
        Symbol symbol = top.getSymbol(unionIndex);
        if (symbol != Symbol.NULL) {
            this.out.writeStartObject();
            this.out.writeFieldName(top.getLabel(unionIndex));
            this.parser.pushSymbol(Symbol.UNION_END);
        }
        this.parser.pushSymbol(symbol);
    }

    @Override
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldAdjustAction) {
            Symbol.FieldAdjustAction fa2 = (Symbol.FieldAdjustAction)top;
            this.out.writeFieldName(fa2.fname);
        } else if (top == Symbol.RECORD_START) {
            this.out.writeStartObject();
        } else if (top == Symbol.RECORD_END || top == Symbol.UNION_END) {
            this.out.writeEndObject();
        } else if (top != Symbol.FIELD_END) {
            throw new AvroTypeException("Unknown action symbol " + top);
        }
        return null;
    }
}

