/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidatingGrammarGenerator {
    public Symbol generate(Schema schema) {
        return Symbol.root(this.generate(schema, new HashMap<LitS, Symbol>()));
    }

    public Symbol generate(Schema sc, Map<LitS, Symbol> seen) {
        switch (sc.getType()) {
            case NULL: {
                return Symbol.NULL;
            }
            case BOOLEAN: {
                return Symbol.BOOLEAN;
            }
            case INT: {
                return Symbol.INT;
            }
            case LONG: {
                return Symbol.LONG;
            }
            case FLOAT: {
                return Symbol.FLOAT;
            }
            case DOUBLE: {
                return Symbol.DOUBLE;
            }
            case STRING: {
                return Symbol.STRING;
            }
            case BYTES: {
                return Symbol.BYTES;
            }
            case FIXED: {
                return Symbol.seq(new Symbol.IntCheckAction(sc.getFixedSize()), Symbol.FIXED);
            }
            case ENUM: {
                return Symbol.seq(new Symbol.IntCheckAction(sc.getEnumSymbols().size()), Symbol.ENUM);
            }
            case ARRAY: {
                return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, this.generate(sc.getElementType(), seen)), Symbol.ARRAY_START);
            }
            case MAP: {
                return Symbol.seq(Symbol.repeat(Symbol.MAP_END, this.generate(sc.getValueType(), seen), Symbol.STRING), Symbol.MAP_START);
            }
            case RECORD: {
                LitS wsc = new LitS(sc);
                Symbol rresult = seen.get(wsc);
                if (rresult == null) {
                    Symbol[] production = new Symbol[sc.getFields().size()];
                    rresult = Symbol.seq(production);
                    seen.put(wsc, rresult);
                    int i2 = production.length;
                    for (Schema.Field f2 : sc.getFields()) {
                        production[--i2] = this.generate(f2.schema(), seen);
                    }
                }
                return rresult;
            }
            case UNION: {
                List<Schema> subs = sc.getTypes();
                Symbol[] symbols = new Symbol[subs.size()];
                String[] labels = new String[subs.size()];
                int i3 = 0;
                for (Schema b2 : sc.getTypes()) {
                    symbols[i3] = this.generate(b2, seen);
                    labels[i3] = b2.getFullName();
                    ++i3;
                }
                return Symbol.seq(Symbol.alt(symbols, labels), Symbol.UNION);
            }
        }
        throw new RuntimeException("Unexpected schema type");
    }

    static class LitS {
        public final Schema actual;

        public LitS(Schema actual) {
            this.actual = actual;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof LitS)) {
                return false;
            }
            return this.actual == ((LitS)o2).actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }
    }
}

