/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.reflect;

import com.flurry.org.apache.avro.AvroRemoteException;
import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Protocol;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.generic.GenericContainer;
import com.flurry.org.apache.avro.generic.GenericFixed;
import com.flurry.org.apache.avro.generic.IndexedRecord;
import com.flurry.org.apache.avro.io.BinaryData;
import com.flurry.org.apache.avro.io.DatumReader;
import com.flurry.org.apache.avro.reflect.Nullable;
import com.flurry.org.apache.avro.reflect.ReflectDatumReader;
import com.flurry.org.apache.avro.reflect.Stringable;
import com.flurry.org.apache.avro.reflect.Union;
import com.flurry.org.apache.avro.specific.FixedSize;
import com.flurry.org.apache.avro.specific.SpecificData;
import com.flurry.org.codehaus.jackson.node.NullNode;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectData
extends SpecificData {
    private static final ReflectData INSTANCE = new ReflectData();
    private static final Map<Class, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap<Class, Map<String, Field>>();
    static final String CLASS_PROP = "java-class";
    static final String ELEMENT_PROP = "java-element-class";
    private static final Class BYTES_CLASS = new byte[0].getClass();
    private static final Schema THROWABLE_MESSAGE = ReflectData.makeNullable(Schema.create(Schema.Type.STRING));
    private final Paranamer paranamer = new CachingParanamer();

    protected ReflectData() {
    }

    public static ReflectData get() {
        return INSTANCE;
    }

    @Override
    public DatumReader createDatumReader(Schema schema) {
        return new ReflectDatumReader(schema, schema, this);
    }

    @Override
    public void setField(Object record, String name, int position, Object o2) {
        if (record instanceof IndexedRecord) {
            super.setField(record, name, position, o2);
            return;
        }
        try {
            ReflectData.getField(record.getClass(), name).set(record, o2);
        }
        catch (IllegalAccessException e2) {
            throw new AvroRuntimeException(e2);
        }
    }

    @Override
    public Object getField(Object record, String name, int position) {
        if (record instanceof IndexedRecord) {
            return super.getField(record, name, position);
        }
        try {
            return ReflectData.getField(record.getClass(), name).get(record);
        }
        catch (IllegalAccessException e2) {
            throw new AvroRuntimeException(e2);
        }
    }

    @Override
    protected boolean isRecord(Object datum) {
        if (datum == null) {
            return false;
        }
        if (super.isRecord(datum)) {
            return true;
        }
        if (datum instanceof Collection) {
            return false;
        }
        return this.getSchema(datum.getClass()).getType() == Schema.Type.RECORD;
    }

    @Override
    protected boolean isArray(Object datum) {
        if (datum == null) {
            return false;
        }
        return datum instanceof Collection || datum.getClass().isArray();
    }

    @Override
    protected boolean isBytes(Object datum) {
        if (datum == null) {
            return false;
        }
        if (super.isBytes(datum)) {
            return true;
        }
        Class<?> c2 = datum.getClass();
        return c2.isArray() && c2.getComponentType() == Byte.TYPE;
    }

    @Override
    protected Schema getRecordSchema(Object record) {
        if (record instanceof GenericContainer) {
            return super.getRecordSchema(record);
        }
        return this.getSchema(record.getClass());
    }

    @Override
    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case ARRAY: {
                if (!datum.getClass().isArray()) {
                    return super.validate(schema, datum);
                }
                int length = Array.getLength(datum);
                for (int i2 = 0; i2 < length; ++i2) {
                    if (this.validate(schema.getElementType(), Array.get(datum, i2))) continue;
                    return false;
                }
                return true;
            }
        }
        return super.validate(schema, datum);
    }

    private static Field getField(Class c2, String name) {
        Field f2;
        Map<String, Field> fields = FIELD_CACHE.get(c2);
        if (fields == null) {
            fields = new ConcurrentHashMap<String, Field>();
            FIELD_CACHE.put(c2, fields);
        }
        if ((f2 = fields.get(name)) == null) {
            f2 = ReflectData.findField(c2, name);
            fields.put(name, f2);
        }
        return f2;
    }

    private static Field findField(Class original, String name) {
        Class c2 = original;
        while (true) {
            try {
                Field f2 = c2.getDeclaredField(name);
                f2.setAccessible(true);
                return f2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((c2 = c2.getSuperclass()) != null) continue;
                throw new AvroRuntimeException("No field named " + name + " in: " + original);
            }
            break;
        }
    }

    static Class getClassProp(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e2) {
            throw new AvroRuntimeException(e2);
        }
    }

    @Override
    public Class getClass(Schema schema) {
        switch (schema.getType()) {
            case ARRAY: {
                Class collectionClass = ReflectData.getClassProp(schema, CLASS_PROP);
                if (collectionClass != null) {
                    return collectionClass;
                }
                return Array.newInstance(this.getClass(schema.getElementType()), 0).getClass();
            }
            case STRING: {
                return String.class;
            }
            case BYTES: {
                return BYTES_CLASS;
            }
            case INT: {
                String intClass = schema.getProp(CLASS_PROP);
                if (Byte.class.getName().equals(intClass)) {
                    return Byte.TYPE;
                }
                if (!Short.class.getName().equals(intClass)) break;
                return Short.TYPE;
            }
        }
        return super.getClass(schema);
    }

    @Override
    protected Schema createSchema(Type type, Map<String, Schema> names) {
        if (type instanceof GenericArrayType) {
            Type component = ((GenericArrayType)type).getGenericComponentType();
            if (component == Byte.TYPE) {
                return Schema.create(Schema.Type.BYTES);
            }
            Schema result = Schema.createArray(this.createSchema(component, names));
            this.setElement(result, component);
            return result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (Map.class.isAssignableFrom(raw)) {
                Type key = params[0];
                Type value = params[1];
                if (key != String.class) {
                    throw new AvroTypeException("Map key class not String: " + key);
                }
                return Schema.createMap(this.createSchema(value, names));
            }
            if (Collection.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                Schema schema = Schema.createArray(this.createSchema(params[0], names));
                schema.addProp(CLASS_PROP, raw.getName());
                return schema;
            }
        } else {
            if (type == Byte.class || type == Byte.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Byte.class.getName());
                return result;
            }
            if (type == Short.class || type == Short.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Short.class.getName());
                return result;
            }
            if (type instanceof Class) {
                Class c2 = (Class)type;
                if (c2.isPrimitive() || Number.class.isAssignableFrom(c2) || c2 == Void.class || c2 == Boolean.class) {
                    return super.createSchema(type, names);
                }
                if (c2.isArray()) {
                    Class<?> component = c2.getComponentType();
                    if (component == Byte.TYPE) {
                        return Schema.create(Schema.Type.BYTES);
                    }
                    Schema result = Schema.createArray(this.createSchema(component, names));
                    this.setElement(result, component);
                    return result;
                }
                if (CharSequence.class.isAssignableFrom(c2)) {
                    return Schema.create(Schema.Type.STRING);
                }
                if (ByteBuffer.class.isAssignableFrom(c2)) {
                    return Schema.create(Schema.Type.BYTES);
                }
                if (Collection.class.isAssignableFrom(c2)) {
                    throw new AvroRuntimeException("Can't find element type of Collection");
                }
                String fullName = c2.getName();
                Schema schema = names.get(fullName);
                if (schema == null) {
                    Union union;
                    String space;
                    String name = c2.getSimpleName();
                    String string = space = c2.getPackage() == null ? "" : c2.getPackage().getName();
                    if (c2.getEnclosingClass() != null) {
                        space = c2.getEnclosingClass().getName() + "$";
                    }
                    if ((union = c2.getAnnotation(Union.class)) != null) {
                        return this.getAnnotatedUnion(union, names);
                    }
                    if (c2.isAnnotationPresent(Stringable.class)) {
                        Schema result = Schema.create(Schema.Type.STRING);
                        result.addProp(CLASS_PROP, c2.getName());
                        return result;
                    }
                    if (c2.isEnum()) {
                        ArrayList<String> symbols = new ArrayList<String>();
                        Enum[] constants = (Enum[])c2.getEnumConstants();
                        for (int i2 = 0; i2 < constants.length; ++i2) {
                            symbols.add(constants[i2].name());
                        }
                        schema = Schema.createEnum(name, null, space, symbols);
                    } else if (GenericFixed.class.isAssignableFrom(c2)) {
                        int size = c2.getAnnotation(FixedSize.class).value();
                        schema = Schema.createFixed(name, null, space, size);
                    } else {
                        if (IndexedRecord.class.isAssignableFrom(c2)) {
                            return super.createSchema(type, names);
                        }
                        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                        boolean error = Throwable.class.isAssignableFrom(c2);
                        schema = Schema.createRecord(name, null, space, error);
                        names.put(c2.getName(), schema);
                        for (Field field : this.getFields(c2)) {
                            Schema defaultType;
                            if ((field.getModifiers() & 0x88) != 0) continue;
                            Schema fieldSchema = this.createFieldSchema(field, names);
                            NullNode defaultValue = null;
                            if (fieldSchema.getType() == Schema.Type.UNION && (defaultType = fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                                defaultValue = NullNode.getInstance();
                            }
                            fields.add(new Schema.Field(field.getName(), fieldSchema, null, defaultValue));
                        }
                        if (error) {
                            fields.add(new Schema.Field("detailMessage", THROWABLE_MESSAGE, null, null));
                        }
                        schema.setFields(fields);
                    }
                    names.put(fullName, schema);
                }
                return schema;
            }
        }
        return super.createSchema(type, names);
    }

    private void setElement(Schema schema, Type element) {
        if (!(element instanceof Class)) {
            return;
        }
        Class c2 = (Class)element;
        Union union = c2.getAnnotation(Union.class);
        if (union != null) {
            schema.addProp(ELEMENT_PROP, c2.getName());
        }
    }

    private Schema getAnnotatedUnion(Union union, Map<String, Schema> names) {
        ArrayList<Schema> branches = new ArrayList<Schema>();
        for (Class branch : union.value()) {
            branches.add(this.createSchema(branch, names));
        }
        return Schema.createUnion(branches);
    }

    public static Schema makeNullable(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), schema));
    }

    private Collection<Field> getFields(Class recordClass) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class c2 = recordClass;
        while (c2.getPackage() == null || !c2.getPackage().getName().startsWith("java.")) {
            for (Field field : c2.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new AvroTypeException(c2 + " contains two fields named: " + field);
            }
            if ((c2 = c2.getSuperclass()) != null) continue;
        }
        return fields.values();
    }

    protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
        Schema schema = this.createSchema(field.getGenericType(), names);
        if (field.isAnnotationPresent(Nullable.class)) {
            schema = ReflectData.makeNullable(schema);
        }
        return schema;
    }

    @Override
    public Protocol getProtocol(Class iface) {
        Protocol protocol = new Protocol(iface.getSimpleName(), iface.getPackage() == null ? "" : iface.getPackage().getName());
        LinkedHashMap<String, Schema> names = new LinkedHashMap<String, Schema>();
        Map<String, Protocol.Message> messages = protocol.getMessages();
        for (Method method : iface.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            String name = method.getName();
            if (messages.containsKey(name)) {
                throw new AvroTypeException("Two methods with same name: " + name);
            }
            messages.put(name, this.getMessage(method, protocol, names));
        }
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.addAll(names.values());
        Collections.reverse(types);
        protocol.setTypes(types);
        return protocol;
    }

    private Protocol.Message getMessage(Method method, Protocol protocol, Map<String, Schema> names) {
        Schema response;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        String[] paramNames = this.paranamer.lookupParameterNames((AccessibleObject)method);
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            Schema paramSchema = this.getSchema(paramTypes[i2], names);
            for (int j2 = 0; j2 < annotations[i2].length; ++j2) {
                if (annotations[i2][j2] instanceof Union) {
                    paramSchema = this.getAnnotatedUnion((Union)annotations[i2][j2], names);
                    continue;
                }
                if (!(annotations[i2][j2] instanceof Nullable)) continue;
                paramSchema = ReflectData.makeNullable(paramSchema);
            }
            String paramName = paramNames.length == paramTypes.length ? paramNames[i2] : paramSchema.getName() + i2;
            fields.add(new Schema.Field(paramName, paramSchema, null, null));
        }
        Schema request = Schema.createRecord(fields);
        Union union = method.getAnnotation(Union.class);
        Schema schema = response = union == null ? this.getSchema(method.getGenericReturnType(), names) : this.getAnnotatedUnion(union, names);
        if (method.isAnnotationPresent(Nullable.class)) {
            response = ReflectData.makeNullable(response);
        }
        ArrayList<Schema> errs = new ArrayList<Schema>();
        errs.add(Protocol.SYSTEM_ERROR);
        for (Type err : method.getGenericExceptionTypes()) {
            if (err == AvroRemoteException.class) continue;
            errs.add(this.getSchema(err, names));
        }
        Schema errors = Schema.createUnion(errs);
        return protocol.createMessage(method.getName(), null, request, response, errors);
    }

    private Schema getSchema(Type type, Map<String, Schema> names) {
        try {
            return this.createSchema(type, names);
        }
        catch (AvroTypeException e2) {
            throw new AvroTypeException("Error getting schema for " + type + ": " + e2.getMessage(), e2);
        }
    }

    @Override
    protected int compare(Object o1, Object o2, Schema s2, boolean equals) {
        switch (s2.getType()) {
            case ARRAY: {
                if (!o1.getClass().isArray()) break;
                Schema elementType = s2.getElementType();
                int l1 = Array.getLength(o1);
                int l2 = Array.getLength(o2);
                int l3 = Math.min(l1, l2);
                for (int i2 = 0; i2 < l3; ++i2) {
                    int compare = this.compare(Array.get(o1, i2), Array.get(o2, i2), elementType, equals);
                    if (compare == 0) continue;
                    return compare;
                }
                return l1 - l2;
            }
            case BYTES: {
                if (!o1.getClass().isArray()) break;
                byte[] b1 = (byte[])o1;
                byte[] b2 = (byte[])o2;
                return BinaryData.compareBytes(b1, 0, b1.length, b2, 0, b2.length);
            }
        }
        return super.compare(o1, o2, s2, equals);
    }

    public static class AllowNull
    extends ReflectData {
        private static final AllowNull INSTANCE = new AllowNull();

        public static AllowNull get() {
            return INSTANCE;
        }

        @Override
        protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
            Schema schema = super.createFieldSchema(field, names);
            return AllowNull.makeNullable(schema);
        }
    }
}

