/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.map.introspect;

import com.flurry.org.codehaus.jackson.map.AnnotationIntrospector;
import com.flurry.org.codehaus.jackson.map.ClassIntrospector;
import com.flurry.org.codehaus.jackson.map.introspect.Annotated;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedField;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMethodMap;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotationMap;
import com.flurry.org.codehaus.jackson.map.introspect.MemberKey;
import com.flurry.org.codehaus.jackson.map.introspect.MethodFilter;
import com.flurry.org.codehaus.jackson.map.util.Annotations;
import com.flurry.org.codehaus.jackson.map.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedClass
extends Annotated {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final Class<?> _class;
    protected final List<Class<?>> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;
    protected AnnotatedConstructor _defaultConstructor;
    protected List<AnnotatedConstructor> _constructors;
    protected List<AnnotatedMethod> _creatorMethods;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;

    private AnnotatedClass(Class<?> cls, List<Class<?>> superTypes, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir, AnnotationMap classAnnotations) {
        this._class = cls;
        this._superTypes = superTypes;
        this._annotationIntrospector = aintr;
        this._mixInResolver = mir;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
        this._classAnnotations = classAnnotations;
    }

    @Override
    public AnnotatedClass withAnnotations(AnnotationMap ann) {
        return new AnnotatedClass(this._class, this._superTypes, this._annotationIntrospector, this._mixInResolver, ann);
    }

    public static AnnotatedClass construct(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        List<Class<?>> st = ClassUtil.findSuperTypes(cls, null);
        AnnotatedClass ac2 = new AnnotatedClass(cls, st, aintr, mir, null);
        ac2.resolveClassAnnotations();
        return ac2;
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        List<Class<?>> empty = Collections.emptyList();
        AnnotatedClass ac2 = new AnnotatedClass(cls, empty, aintr, mir, null);
        ac2.resolveClassAnnotations();
        return ac2;
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._classAnnotations == null) {
            return null;
        }
        return this._classAnnotations.get(acls);
    }

    @Override
    public Type getGenericType() {
        return this._class;
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    protected AnnotationMap getAllAnnotations() {
        return this._classAnnotations;
    }

    public Annotations getAnnotations() {
        return this._classAnnotations;
    }

    public boolean hasAnnotations() {
        return this._classAnnotations.size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        if (this._constructors == null) {
            return Collections.emptyList();
        }
        return this._constructors;
    }

    public List<AnnotatedMethod> getStaticMethods() {
        if (this._creatorMethods == null) {
            return Collections.emptyList();
        }
        return this._creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        return this._memberMethods;
    }

    public int getMemberMethodCount() {
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._memberMethods.find(name, paramTypes);
    }

    public int getFieldCount() {
        return this._fields == null ? 0 : this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            return Collections.emptyList();
        }
        return this._fields;
    }

    public void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        if (this._annotationIntrospector == null) {
            return;
        }
        if (this._primaryMixIn != null) {
            this._addClassMixIns(this._classAnnotations, this._class, this._primaryMixIn);
        }
        for (Annotation a2 : this._class.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a2)) continue;
            this._classAnnotations.addIfNotPresent(a2);
        }
        for (Class<?> cls : this._superTypes) {
            this._addClassMixIns(this._classAnnotations, cls);
            for (Annotation a3 : cls.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a3)) continue;
                this._classAnnotations.addIfNotPresent(a3);
            }
        }
        this._addClassMixIns(this._classAnnotations, Object.class);
    }

    public void resolveCreators(boolean includeAll) {
        this._constructors = null;
        Constructor<?>[] declaredCtors = this._class.getDeclaredConstructors();
        for (Constructor<?> constructor : declaredCtors) {
            if (constructor.getParameterTypes().length == 0) {
                this._defaultConstructor = this._constructConstructor(constructor, true);
                continue;
            }
            if (!includeAll) continue;
            if (this._constructors == null) {
                this._constructors = new ArrayList<AnnotatedConstructor>(Math.max(10, declaredCtors.length));
            }
            this._constructors.add(this._constructConstructor(constructor, false));
        }
        if (this._primaryMixIn != null && (this._defaultConstructor != null || this._constructors != null)) {
            this._addConstructorMixIns(this._primaryMixIn);
        }
        if (this._annotationIntrospector != null) {
            if (this._defaultConstructor != null && this._annotationIntrospector.isIgnorableConstructor(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            if (this._constructors != null) {
                int i2 = this._constructors.size();
                while (--i2 >= 0) {
                    if (!this._annotationIntrospector.isIgnorableConstructor(this._constructors.get(i2))) continue;
                    this._constructors.remove(i2);
                }
            }
        }
        this._creatorMethods = null;
        if (includeAll) {
            for (Executable executable : this._class.getDeclaredMethods()) {
                int argCount;
                if (!Modifier.isStatic(((Method)executable).getModifiers()) || (argCount = ((Method)executable).getParameterTypes().length) < 1) continue;
                if (this._creatorMethods == null) {
                    this._creatorMethods = new ArrayList<AnnotatedMethod>(8);
                }
                this._creatorMethods.add(this._constructCreatorMethod((Method)executable));
            }
            if (this._primaryMixIn != null && this._creatorMethods != null) {
                this._addFactoryMixIns(this._primaryMixIn);
            }
            if (this._annotationIntrospector != null && this._creatorMethods != null) {
                int i3 = this._creatorMethods.size();
                while (--i3 >= 0) {
                    if (!this._annotationIntrospector.isIgnorableMethod(this._creatorMethods.get(i3))) continue;
                    this._creatorMethods.remove(i3);
                }
            }
        }
    }

    public void resolveMemberMethods(MethodFilter methodFilter) {
        Class<?> mixin;
        this._memberMethods = new AnnotatedMethodMap();
        AnnotatedMethodMap mixins = new AnnotatedMethodMap();
        this._addMemberMethods(this._class, methodFilter, this._memberMethods, this._primaryMixIn, mixins);
        for (Class<?> cls : this._superTypes) {
            Class<?> mixin2 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(cls);
            this._addMemberMethods(cls, methodFilter, this._memberMethods, mixin2, mixins);
        }
        if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(methodFilter, this._memberMethods, mixin, mixins);
        }
        if (this._annotationIntrospector != null && !mixins.isEmpty()) {
            for (AnnotatedMethod mixIn : mixins) {
                try {
                    Method m2 = Object.class.getDeclaredMethod(mixIn.getName(), mixIn.getParameterClasses());
                    if (m2 == null) continue;
                    AnnotatedMethod am2 = this._constructMethod(m2);
                    this._addMixOvers(mixIn.getAnnotated(), am2, false);
                    this._memberMethods.add(am2);
                }
                catch (Exception e2) {}
            }
        }
    }

    public void resolveFields() {
        LinkedHashMap<String, AnnotatedField> foundFields = new LinkedHashMap<String, AnnotatedField>();
        this._addFields(foundFields, this._class);
        if (foundFields.isEmpty()) {
            this._fields = Collections.emptyList();
        } else {
            this._fields = new ArrayList<AnnotatedField>(foundFields.size());
            this._fields.addAll(foundFields.values());
        }
    }

    @Deprecated
    public void resolveMemberMethods(MethodFilter methodFilter, boolean collectIgnored) {
        this.resolveMemberMethods(methodFilter);
    }

    @Deprecated
    public void resolveFields(boolean collectIgnored) {
        this.resolveFields();
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotations, toMask, this._mixInResolver.findMixInClassFor(toMask));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask, Class<?> mixin) {
        if (mixin == null) {
            return;
        }
        for (Annotation a2 : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a2)) continue;
            annotations.addIfNotPresent(a2);
        }
        for (Class<?> parent : ClassUtil.findSuperTypes(mixin, toMask)) {
            for (Annotation a3 : parent.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a3)) continue;
                annotations.addIfNotPresent(a3);
            }
        }
    }

    protected void _addConstructorMixIns(Class<?> mixin) {
        MemberKey[] ctorKeys = null;
        int ctorCount = this._constructors == null ? 0 : this._constructors.size();
        block0: for (Constructor<?> ctor : mixin.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length == 0) {
                if (this._defaultConstructor == null) continue;
                this._addMixOvers(ctor, this._defaultConstructor, false);
                continue;
            }
            if (ctorKeys == null) {
                ctorKeys = new MemberKey[ctorCount];
                for (int i2 = 0; i2 < ctorCount; ++i2) {
                    ctorKeys[i2] = new MemberKey((Constructor<?>)this._constructors.get(i2).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(ctor);
            for (int i3 = 0; i3 < ctorCount; ++i3) {
                if (!key.equals(ctorKeys[i3])) continue;
                this._addMixOvers(ctor, this._constructors.get(i3), true);
                continue block0;
            }
        }
    }

    protected void _addFactoryMixIns(Class<?> mixin) {
        MemberKey[] methodKeys = null;
        int methodCount = this._creatorMethods.size();
        block0: for (Method m2 : mixin.getDeclaredMethods()) {
            if (!Modifier.isStatic(m2.getModifiers()) || m2.getParameterTypes().length == 0) continue;
            if (methodKeys == null) {
                methodKeys = new MemberKey[methodCount];
                for (int i2 = 0; i2 < methodCount; ++i2) {
                    methodKeys[i2] = new MemberKey(this._creatorMethods.get(i2).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(m2);
            for (int i3 = 0; i3 < methodCount; ++i3) {
                if (!key.equals(methodKeys[i3])) continue;
                this._addMixOvers(m2, this._creatorMethods.get(i3), true);
                continue block0;
            }
        }
    }

    protected void _addMemberMethods(Class<?> cls, MethodFilter methodFilter, AnnotatedMethodMap methods, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        if (mixInCls != null) {
            this._addMethodMixIns(methodFilter, methods, mixInCls, mixIns);
        }
        if (cls == null) {
            return;
        }
        for (Method m2 : cls.getDeclaredMethods()) {
            if (!this._isIncludableMethod(m2, methodFilter)) continue;
            AnnotatedMethod old = methods.find(m2);
            if (old == null) {
                AnnotatedMethod newM = this._constructMethod(m2);
                methods.add(newM);
                old = mixIns.remove(m2);
                if (old == null) continue;
                this._addMixOvers(old.getAnnotated(), newM, false);
                continue;
            }
            this._addMixUnders(m2, old);
            if (!old.getDeclaringClass().isInterface() || m2.getDeclaringClass().isInterface()) continue;
            methods.add(old.withMethod(m2));
        }
    }

    protected void _addMethodMixIns(MethodFilter methodFilter, AnnotatedMethodMap methods, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        for (Method m2 : mixInCls.getDeclaredMethods()) {
            if (!this._isIncludableMethod(m2, methodFilter)) continue;
            AnnotatedMethod am2 = methods.find(m2);
            if (am2 != null) {
                this._addMixUnders(m2, am2);
                continue;
            }
            mixIns.add(this._constructMethod(m2));
        }
    }

    protected void _addFields(Map<String, AnnotatedField> fields, Class<?> c2) {
        Class<?> parent = c2.getSuperclass();
        if (parent != null) {
            Class<?> mixin;
            this._addFields(fields, parent);
            for (Field f2 : c2.getDeclaredFields()) {
                if (!this._isIncludableField(f2)) continue;
                fields.put(f2.getName(), this._constructField(f2));
            }
            if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(c2)) != null) {
                this._addFieldMixIns(mixin, fields);
            }
        }
    }

    protected void _addFieldMixIns(Class<?> mixin, Map<String, AnnotatedField> fields) {
        for (Field mixinField : mixin.getDeclaredFields()) {
            String name;
            AnnotatedField maskedField;
            if (!this._isIncludableField(mixinField) || (maskedField = fields.get(name = mixinField.getName())) == null) continue;
            for (Annotation a2 : mixinField.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a2)) continue;
                maskedField.addOrOverride(a2);
            }
        }
    }

    protected AnnotatedMethod _constructMethod(Method m2) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(m2, this._emptyAnnotationMap(), null);
        }
        return new AnnotatedMethod(m2, this._collectRelevantAnnotations(m2.getDeclaredAnnotations()), null);
    }

    protected AnnotatedConstructor _constructConstructor(Constructor<?> ctor, boolean defaultCtor) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(ctor, this._emptyAnnotationMap(), this._emptyAnnotationMaps(ctor.getParameterTypes().length));
        }
        if (defaultCtor) {
            return new AnnotatedConstructor(ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), null);
        }
        Annotation[][] paramAnns = ctor.getParameterAnnotations();
        int paramCount = ctor.getParameterTypes().length;
        AnnotationMap[] resolvedAnnotations = null;
        if (paramCount != paramAnns.length) {
            Class<?> dc2 = ctor.getDeclaringClass();
            if (dc2.isEnum() && paramCount == paramAnns.length + 2) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 2][];
                System.arraycopy(old, 0, paramAnns, 2, old.length);
                resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            } else if (dc2.isMemberClass() && paramCount == paramAnns.length + 1) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 1][];
                System.arraycopy(old, 0, paramAnns, 1, old.length);
                resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            }
            if (resolvedAnnotations == null) {
                throw new IllegalStateException("Internal error: constructor for " + ctor.getDeclaringClass().getName() + " has mismatch: " + paramCount + " parameters; " + paramAnns.length + " sets of annotations");
            }
        } else {
            resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
        }
        return new AnnotatedConstructor(ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), resolvedAnnotations);
    }

    protected AnnotatedMethod _constructCreatorMethod(Method m2) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(m2, this._emptyAnnotationMap(), this._emptyAnnotationMaps(m2.getParameterTypes().length));
        }
        return new AnnotatedMethod(m2, this._collectRelevantAnnotations(m2.getDeclaredAnnotations()), this._collectRelevantAnnotations(m2.getParameterAnnotations()));
    }

    protected AnnotatedField _constructField(Field f2) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedField(f2, this._emptyAnnotationMap());
        }
        return new AnnotatedField(f2, this._collectRelevantAnnotations(f2.getDeclaredAnnotations()));
    }

    protected AnnotationMap[] _collectRelevantAnnotations(Annotation[][] anns) {
        int len = anns.length;
        AnnotationMap[] result = new AnnotationMap[len];
        for (int i2 = 0; i2 < len; ++i2) {
            result[i2] = this._collectRelevantAnnotations(anns[i2]);
        }
        return result;
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] anns) {
        AnnotationMap annMap = new AnnotationMap();
        if (anns != null) {
            for (Annotation a2 : anns) {
                if (!this._annotationIntrospector.isHandled(a2)) continue;
                annMap.add(a2);
            }
        }
        return annMap;
    }

    private AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    private AnnotationMap[] _emptyAnnotationMaps(int count) {
        if (count == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] maps = new AnnotationMap[count];
        for (int i2 = 0; i2 < count; ++i2) {
            maps[i2] = this._emptyAnnotationMap();
        }
        return maps;
    }

    protected boolean _isIncludableMethod(Method m2, MethodFilter filter) {
        if (filter != null && !filter.includeMethod(m2)) {
            return false;
        }
        return !m2.isSynthetic() && !m2.isBridge();
    }

    private boolean _isIncludableField(Field f2) {
        if (f2.isSynthetic()) {
            return false;
        }
        int mods = f2.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isTransient(mods);
    }

    protected void _addMixOvers(Constructor<?> mixin, AnnotatedConstructor target, boolean addParamAnnotations) {
        for (Annotation a2 : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a2)) continue;
            target.addOrOverride(a2);
        }
        if (addParamAnnotations) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i2 = 0; i2 < len; ++i2) {
                for (Annotation a3 : pa[i2]) {
                    target.addOrOverrideParam(i2, a3);
                }
            }
        }
    }

    protected void _addMixOvers(Method mixin, AnnotatedMethod target, boolean addParamAnnotations) {
        for (Annotation a2 : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a2)) continue;
            target.addOrOverride(a2);
        }
        if (addParamAnnotations) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i2 = 0; i2 < len; ++i2) {
                for (Annotation a3 : pa[i2]) {
                    target.addOrOverrideParam(i2, a3);
                }
            }
        }
    }

    protected void _addMixUnders(Method src, AnnotatedMethod target) {
        for (Annotation a2 : src.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a2)) continue;
            target.addIfNotPresent(a2);
        }
    }

    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }
}

