/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.map.ser.std;

import com.flurry.org.codehaus.jackson.JsonGenerationException;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.map.JsonMappingException;
import com.flurry.org.codehaus.jackson.map.JsonSerializer;
import com.flurry.org.codehaus.jackson.map.SerializationConfig;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import com.flurry.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import com.flurry.org.codehaus.jackson.node.JsonNodeFactory;
import com.flurry.org.codehaus.jackson.node.ObjectNode;
import com.flurry.org.codehaus.jackson.schema.SchemaAware;
import com.flurry.org.codehaus.jackson.type.JavaType;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializerBase<T>
extends JsonSerializer<T>
implements SchemaAware {
    protected final Class<T> _handledType;

    protected SerializerBase(Class<T> t2) {
        this._handledType = t2;
    }

    protected SerializerBase(JavaType type) {
        this._handledType = type.getRawClass();
    }

    protected SerializerBase(Class<?> t2, boolean dummy) {
        this._handledType = t2;
    }

    @Override
    public final Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String type) {
        ObjectNode schema = this.createObjectNode();
        schema.put("type", type);
        return schema;
    }

    protected ObjectNode createSchemaNode(String type, boolean isOptional) {
        ObjectNode schema = this.createSchemaNode(type);
        if (!isOptional) {
            schema.put("required", !isOptional);
        }
        return schema;
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> serializer) {
        return serializer != null && serializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    public void wrapAndThrow(SerializerProvider provider, Throwable t2, Object bean, String fieldName) throws IOException {
        boolean wrap;
        while (t2 instanceof InvocationTargetException && t2.getCause() != null) {
            t2 = t2.getCause();
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        boolean bl2 = wrap = provider == null || provider.isEnabled(SerializationConfig.Feature.WRAP_EXCEPTIONS);
        if (t2 instanceof IOException) {
            if (!wrap || !(t2 instanceof JsonMappingException)) {
                throw (IOException)t2;
            }
        } else if (!wrap && t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        throw JsonMappingException.wrapWithPath(t2, bean, fieldName);
    }

    public void wrapAndThrow(SerializerProvider provider, Throwable t2, Object bean, int index) throws IOException {
        boolean wrap;
        while (t2 instanceof InvocationTargetException && t2.getCause() != null) {
            t2 = t2.getCause();
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        boolean bl2 = wrap = provider == null || provider.isEnabled(SerializationConfig.Feature.WRAP_EXCEPTIONS);
        if (t2 instanceof IOException) {
            if (!wrap || !(t2 instanceof JsonMappingException)) {
                throw (IOException)t2;
            }
        } else if (!wrap && t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        throw JsonMappingException.wrapWithPath(t2, bean, index);
    }

    @Deprecated
    public void wrapAndThrow(Throwable t2, Object bean, String fieldName) throws IOException {
        this.wrapAndThrow(null, t2, bean, fieldName);
    }

    @Deprecated
    public void wrapAndThrow(Throwable t2, Object bean, int index) throws IOException {
        this.wrapAndThrow(null, t2, bean, index);
    }
}

