/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.enginedata;

public interface IEngineDataManager {
    public boolean init(OnSystemCommandListener var1);

    public void destroy();

    public void pause();

    public void resume();

    public String getVendorInfo();

    public void notifyGameStatus(GameStatus var1, int var2, int var3);

    public void notifyContinuousFrameLost(int var1, int var2, int var3);

    public void notifyLowFps(int var1, float var2, int var3);

    public void notifyFpsChanged(float var1, float var2);

    public static enum GameStatus {
        LAUNCH_BEGIN(0),
        LAUNCH_END(1),
        SCENE_CHANGE_BEGIN(2),
        SCENE_CHANGE_END(3),
        IN_SCENE(4),
        INVALID(5000);

        private int status;

        private GameStatus(int n2) {
            this.status = n2;
        }
    }

    public static interface OnSystemCommandListener {
        public void onQueryFps(int[] var1, int[] var2);

        public void onChangeContinuousFrameLostConfig(int var1, int var2);

        public void onChangeLowFpsConfig(int var1, float var2);

        public void onChangeExpectedFps(int var1);

        public void onChangeSpecialEffectLevel(int var1);

        public void onChangeMuteEnabled(boolean var1);
    }
}

