/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Settings;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLinkData {
    public static final String ARGUMENTS_TAPTIME_KEY = "com.facebook.platform.APPLINK_TAP_TIME_UTC";
    public static final String ARGUMENTS_REFERER_DATA_KEY = "referer_data";
    public static final String ARGUMENTS_NATIVE_CLASS_KEY = "com.facebook.platform.APPLINK_NATIVE_CLASS";
    public static final String ARGUMENTS_NATIVE_URL = "com.facebook.platform.APPLINK_NATIVE_URL";
    static final String BUNDLE_APPLINK_ARGS_KEY = "com.facebook.platform.APPLINK_ARGS";
    private static final String BUNDLE_AL_APPLINK_DATA_KEY = "al_applink_data";
    private static final String APPLINK_BRIDGE_ARGS_KEY = "bridge_args";
    private static final String APPLINK_METHOD_ARGS_KEY = "method_args";
    private static final String APPLINK_VERSION_KEY = "version";
    private static final String BRIDGE_ARGS_METHOD_KEY = "method";
    private static final String DEFERRED_APP_LINK_EVENT = "DEFERRED_APP_LINK";
    private static final String DEFERRED_APP_LINK_PATH = "%s/activities";
    private static final String DEFERRED_APP_LINK_ARGS_FIELD = "applink_args";
    private static final String DEFERRED_APP_LINK_CLASS_FIELD = "applink_class";
    private static final String DEFERRED_APP_LINK_CLICK_TIME_FIELD = "click_time";
    private static final String DEFERRED_APP_LINK_URL_FIELD = "applink_url";
    private static final String METHOD_ARGS_TARGET_URL_KEY = "target_url";
    private static final String METHOD_ARGS_REF_KEY = "ref";
    private static final String REFERER_DATA_REF_KEY = "fb_ref";
    private static final String TAG = AppLinkData.class.getCanonicalName();
    private String ref;
    private Uri targetUri;
    private JSONObject arguments;
    private Bundle argumentBundle;

    public static void fetchDeferredAppLinkData(Context context, CompletionHandler completionHandler) {
        AppLinkData.fetchDeferredAppLinkData(context, null, completionHandler);
    }

    public static void fetchDeferredAppLinkData(Context context, String applicationId, final CompletionHandler completionHandler) {
        Validate.notNull(context, "context");
        Validate.notNull(completionHandler, "completionHandler");
        if (applicationId == null) {
            applicationId = Utility.getMetadataApplicationId(context);
        }
        Validate.notNull(applicationId, "applicationId");
        final Context applicationContext = context.getApplicationContext();
        final String applicationIdCopy = applicationId;
        Settings.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AppLinkData.fetchDeferredAppLinkFromServer(applicationContext, applicationIdCopy, completionHandler);
            }
        });
    }

    private static void fetchDeferredAppLinkFromServer(Context context, String applicationId, CompletionHandler completionHandler) {
        AppLinkData appLinkData;
        block16: {
            GraphObject deferredApplinkParams = GraphObject.Factory.create();
            deferredApplinkParams.setProperty("event", DEFERRED_APP_LINK_EVENT);
            Utility.setAppEventAttributionParameters(deferredApplinkParams, AttributionIdentifiers.getAttributionIdentifiers(context), Utility.getHashedDeviceAndAppID(context, applicationId), Settings.getLimitEventAndDataUsage(context));
            deferredApplinkParams.setProperty("application_package_name", context.getPackageName());
            String deferredApplinkUrlPath = String.format(DEFERRED_APP_LINK_PATH, applicationId);
            appLinkData = null;
            try {
                JSONObject jsonResponse;
                Request deferredApplinkRequest = Request.newPostRequest(null, deferredApplinkUrlPath, deferredApplinkParams, null);
                Response deferredApplinkResponse = deferredApplinkRequest.executeAndWait();
                GraphObject wireResponse = deferredApplinkResponse.getGraphObject();
                JSONObject jSONObject = jsonResponse = wireResponse != null ? wireResponse.getInnerJSONObject() : null;
                if (jsonResponse == null) break block16;
                String appLinkArgsJsonString = jsonResponse.optString(DEFERRED_APP_LINK_ARGS_FIELD);
                long tapTimeUtc = jsonResponse.optLong(DEFERRED_APP_LINK_CLICK_TIME_FIELD, -1L);
                String appLinkClassName = jsonResponse.optString(DEFERRED_APP_LINK_CLASS_FIELD);
                String appLinkUrl = jsonResponse.optString(DEFERRED_APP_LINK_URL_FIELD);
                if (TextUtils.isEmpty((CharSequence)appLinkArgsJsonString)) break block16;
                appLinkData = AppLinkData.createFromJson(appLinkArgsJsonString);
                if (tapTimeUtc != -1L) {
                    try {
                        if (appLinkData.arguments != null) {
                            appLinkData.arguments.put(ARGUMENTS_TAPTIME_KEY, tapTimeUtc);
                        }
                        if (appLinkData.argumentBundle != null) {
                            appLinkData.argumentBundle.putString(ARGUMENTS_TAPTIME_KEY, Long.toString(tapTimeUtc));
                        }
                    }
                    catch (JSONException e) {
                        Log.d((String)TAG, (String)"Unable to put tap time in AppLinkData.arguments");
                    }
                }
                if (appLinkClassName != null) {
                    try {
                        if (appLinkData.arguments != null) {
                            appLinkData.arguments.put(ARGUMENTS_NATIVE_CLASS_KEY, (Object)appLinkClassName);
                        }
                        if (appLinkData.argumentBundle != null) {
                            appLinkData.argumentBundle.putString(ARGUMENTS_NATIVE_CLASS_KEY, appLinkClassName);
                        }
                    }
                    catch (JSONException e) {
                        Log.d((String)TAG, (String)"Unable to put tap time in AppLinkData.arguments");
                    }
                }
                if (appLinkUrl == null) break block16;
                try {
                    if (appLinkData.arguments != null) {
                        appLinkData.arguments.put(ARGUMENTS_NATIVE_URL, (Object)appLinkUrl);
                    }
                    if (appLinkData.argumentBundle != null) {
                        appLinkData.argumentBundle.putString(ARGUMENTS_NATIVE_URL, appLinkUrl);
                    }
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)"Unable to put tap time in AppLinkData.arguments");
                }
            }
            catch (Exception e) {
                Utility.logd(TAG, "Unable to fetch deferred applink from server");
            }
        }
        completionHandler.onDeferredAppLinkDataFetched(appLinkData);
    }

    public static AppLinkData createFromActivity(Activity activity) {
        Validate.notNull(activity, "activity");
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        AppLinkData appLinkData = AppLinkData.createFromAlApplinkData(intent);
        if (appLinkData == null) {
            String appLinkArgsJsonString = intent.getStringExtra(BUNDLE_APPLINK_ARGS_KEY);
            appLinkData = AppLinkData.createFromJson(appLinkArgsJsonString);
        }
        if (appLinkData == null) {
            appLinkData = AppLinkData.createFromUri(intent.getData());
        }
        return appLinkData;
    }

    private static AppLinkData createFromAlApplinkData(Intent intent) {
        String targetUriString;
        Bundle applinks = intent.getBundleExtra(BUNDLE_AL_APPLINK_DATA_KEY);
        if (applinks == null) {
            return null;
        }
        AppLinkData appLinkData = new AppLinkData();
        appLinkData.targetUri = intent.getData();
        if (appLinkData.targetUri == null && (targetUriString = applinks.getString(METHOD_ARGS_TARGET_URL_KEY)) != null) {
            appLinkData.targetUri = Uri.parse((String)targetUriString);
        }
        appLinkData.argumentBundle = applinks;
        appLinkData.arguments = null;
        Bundle refererData = applinks.getBundle(ARGUMENTS_REFERER_DATA_KEY);
        if (refererData != null) {
            appLinkData.ref = refererData.getString(REFERER_DATA_REF_KEY);
        }
        return appLinkData;
    }

    private static AppLinkData createFromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            JSONObject appLinkArgsJson = new JSONObject(jsonString);
            String version = appLinkArgsJson.getString(APPLINK_VERSION_KEY);
            JSONObject bridgeArgs = appLinkArgsJson.getJSONObject(APPLINK_BRIDGE_ARGS_KEY);
            String method = bridgeArgs.getString(BRIDGE_ARGS_METHOD_KEY);
            if (method.equals("applink") && version.equals("2")) {
                JSONObject refererData;
                AppLinkData appLinkData = new AppLinkData();
                appLinkData.arguments = appLinkArgsJson.getJSONObject(APPLINK_METHOD_ARGS_KEY);
                if (appLinkData.arguments.has(METHOD_ARGS_REF_KEY)) {
                    appLinkData.ref = appLinkData.arguments.getString(METHOD_ARGS_REF_KEY);
                } else if (appLinkData.arguments.has(ARGUMENTS_REFERER_DATA_KEY) && (refererData = appLinkData.arguments.getJSONObject(ARGUMENTS_REFERER_DATA_KEY)).has(REFERER_DATA_REF_KEY)) {
                    appLinkData.ref = refererData.getString(REFERER_DATA_REF_KEY);
                }
                if (appLinkData.arguments.has(METHOD_ARGS_TARGET_URL_KEY)) {
                    appLinkData.targetUri = Uri.parse((String)appLinkData.arguments.getString(METHOD_ARGS_TARGET_URL_KEY));
                }
                appLinkData.argumentBundle = AppLinkData.toBundle(appLinkData.arguments);
                return appLinkData;
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Unable to parse AppLink JSON", (Throwable)e);
        }
        catch (FacebookException e) {
            Log.d((String)TAG, (String)"Unable to parse AppLink JSON", (Throwable)e);
        }
        return null;
    }

    private static AppLinkData createFromUri(Uri appLinkDataUri) {
        if (appLinkDataUri == null) {
            return null;
        }
        AppLinkData appLinkData = new AppLinkData();
        appLinkData.targetUri = appLinkDataUri;
        return appLinkData;
    }

    private static Bundle toBundle(JSONObject node) throws JSONException {
        Bundle bundle = new Bundle();
        Iterator fields = node.keys();
        while (fields.hasNext()) {
            String key = (String)fields.next();
            Object value = node.get(key);
            if (value instanceof JSONObject) {
                bundle.putBundle(key, AppLinkData.toBundle((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                int i;
                JSONArray valueArr = (JSONArray)value;
                if (valueArr.length() == 0) {
                    bundle.putStringArray(key, new String[0]);
                    continue;
                }
                Object firstNode = valueArr.get(0);
                if (firstNode instanceof JSONObject) {
                    Bundle[] bundles = new Bundle[valueArr.length()];
                    i = 0;
                    while (i < valueArr.length()) {
                        bundles[i] = AppLinkData.toBundle(valueArr.getJSONObject(i));
                        ++i;
                    }
                    bundle.putParcelableArray(key, (Parcelable[])bundles);
                    continue;
                }
                if (firstNode instanceof JSONArray) {
                    throw new FacebookException("Nested arrays are not supported.");
                }
                String[] arrValues = new String[valueArr.length()];
                i = 0;
                while (i < valueArr.length()) {
                    arrValues[i] = valueArr.get(i).toString();
                    ++i;
                }
                bundle.putStringArray(key, arrValues);
                continue;
            }
            bundle.putString(key, value.toString());
        }
        return bundle;
    }

    private AppLinkData() {
    }

    public Uri getTargetUri() {
        return this.targetUri;
    }

    public String getRef() {
        return this.ref;
    }

    @Deprecated
    public JSONObject getArguments() {
        return this.arguments;
    }

    public Bundle getArgumentBundle() {
        return this.argumentBundle;
    }

    public Bundle getRefererData() {
        if (this.argumentBundle != null) {
            return this.argumentBundle.getBundle(ARGUMENTS_REFERER_DATA_KEY);
        }
        return null;
    }

    public static interface CompletionHandler {
        public void onDeferredAppLinkDataFetched(AppLinkData var1);
    }
}

