/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.HttpMethod;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.GraphUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSession
extends Session {
    private static final long serialVersionUID = 1L;
    private static final String LOG_TAG = "FacebookSDK.TestSession";
    private static Map<String, TestAccount> appTestAccounts;
    private static String testApplicationSecret;
    private static String testApplicationId;
    private final String sessionUniqueUserTag;
    private final List<String> requestedPermissions;
    private final Mode mode;
    private String testAccountId;
    private String testAccountUserName;
    private boolean wasAskedToExtendAccessToken;

    TestSession(Activity activity, List<String> permissions, TokenCachingStrategy tokenCachingStrategy, String sessionUniqueUserTag, Mode mode) {
        super((Context)activity, testApplicationId, tokenCachingStrategy);
        Validate.notNull(permissions, "permissions");
        Validate.notNullOrEmpty(testApplicationId, "testApplicationId");
        Validate.notNullOrEmpty(testApplicationSecret, "testApplicationSecret");
        this.sessionUniqueUserTag = sessionUniqueUserTag;
        this.mode = mode;
        this.requestedPermissions = permissions;
    }

    public static TestSession createSessionWithPrivateUser(Activity activity, List<String> permissions) {
        return TestSession.createTestSession(activity, permissions, Mode.PRIVATE, null);
    }

    public static TestSession createSessionWithSharedUser(Activity activity, List<String> permissions) {
        return TestSession.createSessionWithSharedUser(activity, permissions, null);
    }

    public static TestSession createSessionWithSharedUser(Activity activity, List<String> permissions, String sessionUniqueUserTag) {
        return TestSession.createTestSession(activity, permissions, Mode.SHARED, sessionUniqueUserTag);
    }

    public static synchronized String getTestApplicationId() {
        return testApplicationId;
    }

    public static synchronized void setTestApplicationId(String applicationId) {
        if (testApplicationId != null && !testApplicationId.equals(applicationId)) {
            throw new FacebookException("Can't have more than one test application ID");
        }
        testApplicationId = applicationId;
    }

    public static synchronized String getTestApplicationSecret() {
        return testApplicationSecret;
    }

    public static synchronized void setTestApplicationSecret(String applicationSecret) {
        if (testApplicationSecret != null && !testApplicationSecret.equals(applicationSecret)) {
            throw new FacebookException("Can't have more than one test application secret");
        }
        testApplicationSecret = applicationSecret;
    }

    public final String getTestUserId() {
        return this.testAccountId;
    }

    public final String getTestUserName() {
        return this.testAccountUserName;
    }

    private static synchronized TestSession createTestSession(Activity activity, List<String> permissions, Mode mode, String sessionUniqueUserTag) {
        if (Utility.isNullOrEmpty(testApplicationId) || Utility.isNullOrEmpty(testApplicationSecret)) {
            throw new FacebookException("Must provide app ID and secret");
        }
        if (Utility.isNullOrEmpty(permissions)) {
            permissions = Arrays.asList("email", "publish_actions");
        }
        return new TestSession(activity, permissions, new TestTokenCachingStrategy(), sessionUniqueUserTag, mode);
    }

    private static synchronized void retrieveTestAccountsForAppIfNeeded() {
        if (appTestAccounts != null) {
            return;
        }
        appTestAccounts = new HashMap<String, TestAccount>();
        Request.setDefaultBatchApplicationId(testApplicationId);
        Bundle parameters = new Bundle();
        parameters.putString("access_token", TestSession.getAppAccessToken());
        Request requestTestUsers = new Request(null, "app/accounts/test-users", parameters, null);
        requestTestUsers.setBatchEntryName("testUsers");
        requestTestUsers.setBatchEntryOmitResultOnSuccess(false);
        Bundle testUserNamesParam = new Bundle();
        testUserNamesParam.putString("access_token", TestSession.getAppAccessToken());
        testUserNamesParam.putString("ids", "{result=testUsers:$.data.*.id}");
        testUserNamesParam.putString("fields", "name");
        Request requestTestUserNames = new Request(null, "", testUserNamesParam, null);
        requestTestUserNames.setBatchEntryDependsOn("testUsers");
        List<Response> responses = Request.executeBatchAndWait(requestTestUsers, requestTestUserNames);
        if (responses == null || responses.size() != 2) {
            throw new FacebookException("Unexpected number of results from TestUsers batch query");
        }
        TestAccountsResponse testAccountsResponse = responses.get(0).getGraphObjectAs(TestAccountsResponse.class);
        GraphObjectList<TestAccount> testAccounts = testAccountsResponse.getData();
        GraphObject userAccountsMap = responses.get(1).getGraphObject();
        TestSession.populateTestAccounts(testAccounts, userAccountsMap);
    }

    private static synchronized void populateTestAccounts(Collection<TestAccount> testAccounts, GraphObject userAccountsMap) {
        for (TestAccount testAccount : testAccounts) {
            GraphUser testUser = userAccountsMap.getPropertyAs(testAccount.getId(), GraphUser.class);
            testAccount.setName(testUser.getName());
            TestSession.storeTestAccount(testAccount);
        }
    }

    private static synchronized void storeTestAccount(TestAccount testAccount) {
        appTestAccounts.put(testAccount.getId(), testAccount);
    }

    private static synchronized TestAccount findTestAccountMatchingIdentifier(String identifier) {
        TestSession.retrieveTestAccountsForAppIfNeeded();
        for (TestAccount testAccount : appTestAccounts.values()) {
            if (!testAccount.getName().contains(identifier)) continue;
            return testAccount;
        }
        return null;
    }

    @Override
    public final String toString() {
        String superString = super.toString();
        return "{TestSession" + " testUserId:" + this.testAccountId + " " + superString + "}";
    }

    @Override
    void authorize(Session.AuthorizationRequest request) {
        if (this.mode == Mode.PRIVATE) {
            this.createTestAccountAndFinishAuth();
        } else {
            this.findOrCreateSharedTestAccount();
        }
    }

    @Override
    void postStateChange(SessionState oldState, SessionState newState, Exception error) {
        String id2 = this.testAccountId;
        super.postStateChange(oldState, newState, error);
        if (newState.isClosed() && id2 != null && this.mode == Mode.PRIVATE) {
            this.deleteTestAccount(id2, TestSession.getAppAccessToken());
        }
    }

    boolean getWasAskedToExtendAccessToken() {
        return this.wasAskedToExtendAccessToken;
    }

    void forceExtendAccessToken(boolean forceExtendAccessToken) {
        AccessToken currentToken = this.getTokenInfo();
        this.setTokenInfo(new AccessToken(currentToken.getToken(), new Date(), currentToken.getPermissions(), currentToken.getDeclinedPermissions(), AccessTokenSource.TEST_USER, new Date(0L)));
        this.setLastAttemptedTokenExtendDate(new Date(0L));
    }

    @Override
    boolean shouldExtendAccessToken() {
        boolean result = super.shouldExtendAccessToken();
        this.wasAskedToExtendAccessToken = false;
        return result;
    }

    @Override
    void extendAccessToken() {
        this.wasAskedToExtendAccessToken = true;
        super.extendAccessToken();
    }

    void fakeTokenRefreshAttempt() {
        this.setCurrentTokenRefreshRequest(new Session.TokenRefreshRequest());
    }

    static final String getAppAccessToken() {
        return String.valueOf(testApplicationId) + "|" + testApplicationSecret;
    }

    private void findOrCreateSharedTestAccount() {
        TestAccount testAccount = TestSession.findTestAccountMatchingIdentifier(this.getSharedTestAccountIdentifier());
        if (testAccount != null) {
            this.finishAuthWithTestAccount(testAccount);
        } else {
            this.createTestAccountAndFinishAuth();
        }
    }

    private void finishAuthWithTestAccount(TestAccount testAccount) {
        this.testAccountId = testAccount.getId();
        this.testAccountUserName = testAccount.getName();
        AccessToken accessToken = AccessToken.createFromString(testAccount.getAccessToken(), this.requestedPermissions, AccessTokenSource.TEST_USER);
        this.finishAuthOrReauth(accessToken, null);
    }

    private TestAccount createTestAccountAndFinishAuth() {
        Bundle parameters = new Bundle();
        parameters.putString("installed", "true");
        parameters.putString("permissions", this.getPermissionsString());
        parameters.putString("access_token", TestSession.getAppAccessToken());
        if (this.mode == Mode.SHARED) {
            parameters.putString("name", String.format("Shared %s Testuser", this.getSharedTestAccountIdentifier()));
        }
        String graphPath = String.format("%s/accounts/test-users", testApplicationId);
        Request createUserRequest = new Request(null, graphPath, parameters, HttpMethod.POST);
        Response response = createUserRequest.executeAndWait();
        FacebookRequestError error = response.getError();
        TestAccount testAccount = response.getGraphObjectAs(TestAccount.class);
        if (error != null) {
            this.finishAuthOrReauth(null, error.getException());
            return null;
        }
        assert (testAccount != null);
        if (this.mode == Mode.SHARED) {
            testAccount.setName(parameters.getString("name"));
            TestSession.storeTestAccount(testAccount);
        }
        this.finishAuthWithTestAccount(testAccount);
        return testAccount;
    }

    private void deleteTestAccount(String testAccountId, String appAccessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("access_token", appAccessToken);
        Request request = new Request(null, testAccountId, parameters, HttpMethod.DELETE);
        Response response = request.executeAndWait();
        FacebookRequestError error = response.getError();
        GraphObject graphObject = response.getGraphObject();
        if (error != null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not delete test account %s: %s", testAccountId, error.getException().toString()));
        } else if (graphObject.getProperty("FACEBOOK_NON_JSON_RESULT") == Boolean.valueOf(false) || graphObject.getProperty("success") == Boolean.valueOf(false)) {
            Log.w((String)LOG_TAG, (String)String.format("Could not delete test account %s: unknown reason", testAccountId));
        }
    }

    private String getPermissionsString() {
        return TextUtils.join((CharSequence)",", this.requestedPermissions);
    }

    private String getSharedTestAccountIdentifier() {
        long permissionsHash = (long)this.getPermissionsString().hashCode() & 0xFFFFFFFFL;
        long sessionTagHash = this.sessionUniqueUserTag != null ? (long)this.sessionUniqueUserTag.hashCode() & 0xFFFFFFFFL : 0L;
        long combinedHash = permissionsHash ^ sessionTagHash;
        return this.validNameStringFromInteger(combinedHash);
    }

    private String validNameStringFromInteger(long i) {
        String s = Long.toString(i);
        StringBuilder result = new StringBuilder("Perm");
        char lastChar = '\u0000';
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == lastChar) {
                c = (char)(c + 10);
            }
            result.append((char)(c + 97 - 48));
            lastChar = c;
            ++n2;
        }
        return result.toString();
    }

    private static enum Mode {
        PRIVATE,
        SHARED;

    }

    private static interface TestAccount
    extends GraphObject {
        public String getId();

        public String getAccessToken();

        public String getName();

        public void setName(String var1);
    }

    private static interface TestAccountsResponse
    extends GraphObject {
        public GraphObjectList<TestAccount> getData();
    }

    private static final class TestTokenCachingStrategy
    extends TokenCachingStrategy {
        private Bundle bundle;

        private TestTokenCachingStrategy() {
        }

        @Override
        public Bundle load() {
            return this.bundle;
        }

        @Override
        public void save(Bundle value) {
            this.bundle = value;
        }

        @Override
        public void clear() {
            this.bundle = null;
        }
    }
}

