/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.facebook.FacebookException;
import com.facebook.android.R;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.model.GraphObject;
import com.facebook.widget.GraphObjectCursor;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

class GraphObjectAdapter<T extends GraphObject>
extends BaseAdapter
implements SectionIndexer {
    private static final int DISPLAY_SECTIONS_THRESHOLD = 1;
    private static final int HEADER_VIEW_TYPE = 0;
    private static final int GRAPH_OBJECT_VIEW_TYPE = 1;
    private static final int ACTIVITY_CIRCLE_VIEW_TYPE = 2;
    private static final int MAX_PREFETCHED_PICTURES = 20;
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PICTURE = "picture";
    private final Map<String, ImageRequest> pendingRequests = new HashMap<String, ImageRequest>();
    private final LayoutInflater inflater;
    private List<String> sectionKeys = new ArrayList<String>();
    private Map<String, ArrayList<T>> graphObjectsBySection = new HashMap<String, ArrayList<T>>();
    private Map<String, T> graphObjectsById = new HashMap<String, T>();
    private boolean displaySections;
    private List<String> sortFields;
    private String groupByField;
    private boolean showPicture;
    private boolean showCheckbox;
    private Filter<T> filter;
    private DataNeededListener dataNeededListener;
    private GraphObjectCursor<T> cursor;
    private Context context;
    private Map<String, ImageResponse> prefetchedPictureCache = new HashMap<String, ImageResponse>();
    private ArrayList<String> prefetchedProfilePictureIds = new ArrayList();
    private OnErrorListener onErrorListener;

    public GraphObjectAdapter(Context context) {
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public List<String> getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(List<String> sortFields) {
        this.sortFields = sortFields;
    }

    public String getGroupByField() {
        return this.groupByField;
    }

    public void setGroupByField(String groupByField) {
        this.groupByField = groupByField;
    }

    public boolean getShowPicture() {
        return this.showPicture;
    }

    public void setShowPicture(boolean showPicture) {
        this.showPicture = showPicture;
    }

    public boolean getShowCheckbox() {
        return this.showCheckbox;
    }

    public void setShowCheckbox(boolean showCheckbox) {
        this.showCheckbox = showCheckbox;
    }

    public DataNeededListener getDataNeededListener() {
        return this.dataNeededListener;
    }

    public void setDataNeededListener(DataNeededListener dataNeededListener) {
        this.dataNeededListener = dataNeededListener;
    }

    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public GraphObjectCursor<T> getCursor() {
        return this.cursor;
    }

    public boolean changeCursor(GraphObjectCursor<T> cursor) {
        if (this.cursor == cursor) {
            return false;
        }
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = cursor;
        this.rebuildAndNotify();
        return true;
    }

    public void rebuildAndNotify() {
        this.rebuildSections();
        this.notifyDataSetChanged();
    }

    public void prioritizeViewRange(int firstVisibleItem, int lastVisibleItem, int prefetchBuffer) {
        SectionAndItem<T> sectionAndItem;
        if (lastVisibleItem < firstVisibleItem || this.sectionKeys.size() == 0) {
            return;
        }
        int i = lastVisibleItem;
        while (i >= 0) {
            String id2;
            ImageRequest request;
            SectionAndItem<T> sectionAndItem2 = this.getSectionAndItem(i);
            if (sectionAndItem2.graphObject != null && (request = this.pendingRequests.get(id2 = this.getIdOfGraphObject(sectionAndItem2.graphObject))) != null) {
                ImageDownloader.prioritizeRequest(request);
            }
            --i;
        }
        int start = Math.max(0, firstVisibleItem - prefetchBuffer);
        int end = Math.min(lastVisibleItem + prefetchBuffer, this.getCount() - 1);
        ArrayList graphObjectsToPrefetchPicturesFor = new ArrayList();
        int i2 = start;
        while (i2 < firstVisibleItem) {
            sectionAndItem = this.getSectionAndItem(i2);
            if (sectionAndItem.graphObject != null) {
                graphObjectsToPrefetchPicturesFor.add(sectionAndItem.graphObject);
            }
            ++i2;
        }
        i2 = lastVisibleItem + 1;
        while (i2 <= end) {
            sectionAndItem = this.getSectionAndItem(i2);
            if (sectionAndItem.graphObject != null) {
                graphObjectsToPrefetchPicturesFor.add(sectionAndItem.graphObject);
            }
            ++i2;
        }
        for (GraphObject graphObject : graphObjectsToPrefetchPicturesFor) {
            URI uri = this.getPictureUriOfGraphObject(graphObject);
            String id3 = this.getIdOfGraphObject(graphObject);
            boolean alreadyPrefetching = this.prefetchedProfilePictureIds.remove(id3);
            this.prefetchedProfilePictureIds.add(id3);
            if (alreadyPrefetching) continue;
            this.downloadProfilePicture(id3, uri, null);
        }
    }

    protected String getSectionKeyOfGraphObject(T graphObject) {
        String result = null;
        if (this.groupByField != null && (result = (String)graphObject.getProperty(this.groupByField)) != null && result.length() > 0) {
            result = result.substring(0, 1).toUpperCase();
        }
        return result != null ? result : "";
    }

    protected CharSequence getTitleOfGraphObject(T graphObject) {
        return (String)graphObject.getProperty(NAME);
    }

    protected CharSequence getSubTitleOfGraphObject(T graphObject) {
        return null;
    }

    protected URI getPictureUriOfGraphObject(T graphObject) {
        ItemPicture itemPicture;
        ItemPictureData data;
        String uri = null;
        Object o = graphObject.getProperty(PICTURE);
        if (o instanceof String) {
            uri = (String)o;
        } else if (o instanceof JSONObject && (data = (itemPicture = GraphObject.Factory.create((JSONObject)o).cast(ItemPicture.class)).getData()) != null) {
            uri = data.getUrl();
        }
        if (uri != null) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    protected View getSectionHeaderView(String sectionHeader, View convertView, ViewGroup parent) {
        TextView result = (TextView)convertView;
        if (result == null) {
            result = (TextView)this.inflater.inflate(R.layout.com_facebook_picker_list_section_header, null);
        }
        result.setText((CharSequence)sectionHeader);
        return result;
    }

    protected View getGraphObjectView(T graphObject, View convertView, ViewGroup parent) {
        View result = convertView;
        if (result == null) {
            result = this.createGraphObjectView(graphObject);
        }
        this.populateGraphObjectView(result, graphObject);
        return result;
    }

    private View getActivityCircleView(View convertView, ViewGroup parent) {
        View result = convertView;
        if (result == null) {
            result = this.inflater.inflate(R.layout.com_facebook_picker_activity_circle_row, null);
        }
        ProgressBar activityCircle = (ProgressBar)result.findViewById(R.id.com_facebook_picker_row_activity_circle);
        activityCircle.setVisibility(0);
        return result;
    }

    protected int getGraphObjectRowLayoutId(T graphObject) {
        return R.layout.com_facebook_picker_list_row;
    }

    protected int getDefaultPicture() {
        return R.drawable.com_facebook_profile_default_icon;
    }

    protected View createGraphObjectView(T graphObject) {
        View result = this.inflater.inflate(this.getGraphObjectRowLayoutId(graphObject), null);
        ViewStub checkboxStub = (ViewStub)result.findViewById(R.id.com_facebook_picker_checkbox_stub);
        if (checkboxStub != null) {
            if (!this.getShowCheckbox()) {
                checkboxStub.setVisibility(8);
            } else {
                CheckBox checkBox = (CheckBox)checkboxStub.inflate();
                this.updateCheckboxState(checkBox, false);
            }
        }
        ViewStub profilePicStub = (ViewStub)result.findViewById(R.id.com_facebook_picker_profile_pic_stub);
        if (!this.getShowPicture()) {
            profilePicStub.setVisibility(8);
        } else {
            ImageView imageView = (ImageView)profilePicStub.inflate();
            imageView.setVisibility(0);
        }
        return result;
    }

    protected void populateGraphObjectView(View view, T graphObject) {
        URI pictureURI;
        String id2 = this.getIdOfGraphObject(graphObject);
        view.setTag((Object)id2);
        CharSequence title = this.getTitleOfGraphObject(graphObject);
        TextView titleView = (TextView)view.findViewById(R.id.com_facebook_picker_title);
        if (titleView != null) {
            titleView.setText(title, TextView.BufferType.SPANNABLE);
        }
        CharSequence subtitle = this.getSubTitleOfGraphObject(graphObject);
        TextView subtitleView = (TextView)view.findViewById(R.id.picker_subtitle);
        if (subtitleView != null) {
            if (subtitle != null) {
                subtitleView.setText(subtitle, TextView.BufferType.SPANNABLE);
                subtitleView.setVisibility(0);
            } else {
                subtitleView.setVisibility(8);
            }
        }
        if (this.getShowCheckbox()) {
            CheckBox checkBox = (CheckBox)view.findViewById(R.id.com_facebook_picker_checkbox);
            this.updateCheckboxState(checkBox, this.isGraphObjectSelected(id2));
        }
        if (this.getShowPicture() && (pictureURI = this.getPictureUriOfGraphObject(graphObject)) != null) {
            ImageView profilePic = (ImageView)view.findViewById(R.id.com_facebook_picker_image);
            if (this.prefetchedPictureCache.containsKey(id2)) {
                ImageResponse response = this.prefetchedPictureCache.get(id2);
                profilePic.setImageBitmap(response.getBitmap());
                profilePic.setTag((Object)response.getRequest().getImageUri());
            } else {
                this.downloadProfilePicture(id2, pictureURI, profilePic);
            }
        }
    }

    String getIdOfGraphObject(T graphObject) {
        Object obj;
        if (graphObject.asMap().containsKey(ID) && (obj = graphObject.getProperty(ID)) instanceof String) {
            return (String)obj;
        }
        throw new FacebookException("Received an object without an ID.");
    }

    boolean filterIncludesItem(T graphObject) {
        return this.filter == null || this.filter.includeItem(graphObject);
    }

    Filter<T> getFilter() {
        return this.filter;
    }

    void setFilter(Filter<T> filter) {
        this.filter = filter;
    }

    boolean isGraphObjectSelected(String graphObjectId) {
        return false;
    }

    void updateCheckboxState(CheckBox checkBox, boolean graphObjectSelected) {
    }

    String getPictureFieldSpecifier() {
        View view = this.createGraphObjectView(null);
        ImageView picture = (ImageView)view.findViewById(R.id.com_facebook_picker_image);
        if (picture == null) {
            return null;
        }
        ViewGroup.LayoutParams layoutParams = picture.getLayoutParams();
        return String.format(Locale.US, "picture.height(%d).width(%d)", layoutParams.height, layoutParams.width);
    }

    private boolean shouldShowActivityCircleCell() {
        return this.cursor != null && this.cursor.areMoreObjectsAvailable() && this.dataNeededListener != null && !this.isEmpty();
    }

    private void rebuildSections() {
        this.sectionKeys = new ArrayList<String>();
        this.graphObjectsBySection = new HashMap<String, ArrayList<T>>();
        this.graphObjectsById = new HashMap<String, T>();
        this.displaySections = false;
        if (this.cursor == null || this.cursor.getCount() == 0) {
            return;
        }
        int objectsAdded = 0;
        this.cursor.moveToFirst();
        do {
            T graphObject;
            if (!this.filterIncludesItem(graphObject = this.cursor.getGraphObject())) continue;
            ++objectsAdded;
            String string2 = this.getSectionKeyOfGraphObject(graphObject);
            if (!this.graphObjectsBySection.containsKey(string2)) {
                this.sectionKeys.add(string2);
                this.graphObjectsBySection.put(string2, new ArrayList());
            }
            List section = this.graphObjectsBySection.get(string2);
            section.add(graphObject);
            this.graphObjectsById.put(this.getIdOfGraphObject(graphObject), graphObject);
        } while (this.cursor.moveToNext());
        if (this.sortFields != null) {
            final Collator collator = Collator.getInstance();
            for (List list : this.graphObjectsBySection.values()) {
                Collections.sort(list, new Comparator<GraphObject>(){

                    @Override
                    public int compare(GraphObject a, GraphObject b) {
                        return GraphObjectAdapter.compareGraphObjects(a, b, GraphObjectAdapter.this.sortFields, collator);
                    }
                });
            }
        }
        Collections.sort(this.sectionKeys, Collator.getInstance());
        this.displaySections = this.sectionKeys.size() > 1 && objectsAdded > 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    SectionAndItem<T> getSectionAndItem(int position) {
        GraphObject graphObject;
        String sectionKey;
        block9: {
            if (this.sectionKeys.size() == 0) {
                return null;
            }
            sectionKey = null;
            graphObject = null;
            if (!this.displaySections) {
                sectionKey = this.sectionKeys.get(0);
                List section = this.graphObjectsBySection.get(sectionKey);
                if (position >= 0 && position < section.size()) {
                    graphObject = (GraphObject)this.graphObjectsBySection.get(sectionKey).get(position);
                    break block9;
                } else {
                    assert (this.dataNeededListener != null && this.cursor.areMoreObjectsAvailable());
                    return new SectionAndItem<Object>(null, null);
                }
            }
            for (String key : this.sectionKeys) {
                if (position-- == 0) {
                    sectionKey = key;
                    break;
                }
                List section = this.graphObjectsBySection.get(key);
                if (position < section.size()) {
                    sectionKey = key;
                    graphObject = (GraphObject)section.get(position);
                    break;
                }
                position -= section.size();
            }
        }
        if (sectionKey != null) {
            return new SectionAndItem<Object>(sectionKey, graphObject);
        }
        throw new IndexOutOfBoundsException("position");
    }

    int getPosition(String sectionKey, T graphObject) {
        int position = 0;
        boolean found = false;
        for (String key : this.sectionKeys) {
            if (this.displaySections) {
                ++position;
            }
            if (key.equals(sectionKey)) {
                found = true;
                break;
            }
            position += this.graphObjectsBySection.get(key).size();
        }
        if (!found) {
            return -1;
        }
        if (graphObject == null) {
            return position - (this.displaySections ? 1 : 0);
        }
        for (GraphObject t : this.graphObjectsBySection.get(sectionKey)) {
            if (GraphObject.Factory.hasSameId(t, graphObject)) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.sectionKeys.size() == 0;
    }

    public int getCount() {
        if (this.sectionKeys.size() == 0) {
            return 0;
        }
        int count = this.displaySections ? this.sectionKeys.size() : 0;
        for (List list : this.graphObjectsBySection.values()) {
            count += list.size();
        }
        if (this.shouldShowActivityCircleCell()) {
            ++count;
        }
        return count;
    }

    public boolean areAllItemsEnabled() {
        return this.displaySections;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isEnabled(int position) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(position);
        return sectionAndItem.getType() == SectionAndItem.Type.GRAPH_OBJECT;
    }

    public Object getItem(int position) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(position);
        return sectionAndItem.getType() == SectionAndItem.Type.GRAPH_OBJECT ? sectionAndItem.graphObject : null;
    }

    public long getItemId(int position) {
        String id2;
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(position);
        if (sectionAndItem != null && sectionAndItem.graphObject != null && (id2 = this.getIdOfGraphObject(sectionAndItem.graphObject)) != null) {
            try {
                return Long.parseLong(id2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(position);
        switch (sectionAndItem.getType()) {
            case SECTION_HEADER: {
                return 0;
            }
            case GRAPH_OBJECT: {
                return 1;
            }
            case ACTIVITY_CIRCLE: {
                return 2;
            }
        }
        throw new FacebookException("Unexpected type of section and item.");
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(position);
        switch (sectionAndItem.getType()) {
            case SECTION_HEADER: {
                return this.getSectionHeaderView(sectionAndItem.sectionKey, convertView, parent);
            }
            case GRAPH_OBJECT: {
                return this.getGraphObjectView(sectionAndItem.graphObject, convertView, parent);
            }
            case ACTIVITY_CIRCLE: {
                assert (this.cursor.areMoreObjectsAvailable() && this.dataNeededListener != null);
                this.dataNeededListener.onDataNeeded();
                return this.getActivityCircleView(convertView, parent);
            }
        }
        throw new FacebookException("Unexpected type of section and item.");
    }

    public Object[] getSections() {
        if (this.displaySections) {
            return this.sectionKeys.toArray();
        }
        return new Object[0];
    }

    public int getPositionForSection(int section) {
        if (this.displaySections && (section = Math.max(0, Math.min(section, this.sectionKeys.size() - 1))) < this.sectionKeys.size()) {
            return this.getPosition(this.sectionKeys.get(section), null);
        }
        return 0;
    }

    public int getSectionForPosition(int position) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(position);
        if (sectionAndItem != null && sectionAndItem.getType() != SectionAndItem.Type.ACTIVITY_CIRCLE) {
            return Math.max(0, Math.min(this.sectionKeys.indexOf(sectionAndItem.sectionKey), this.sectionKeys.size() - 1));
        }
        return 0;
    }

    public List<T> getGraphObjectsById(Collection<String> ids) {
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(ids);
        ArrayList<GraphObject> result = new ArrayList<GraphObject>(idSet.size());
        for (String id2 : idSet) {
            GraphObject graphObject = (GraphObject)this.graphObjectsById.get(id2);
            if (graphObject == null) continue;
            result.add(graphObject);
        }
        return result;
    }

    private void downloadProfilePicture(final String profileId, URI pictureURI, final ImageView imageView) {
        boolean prefetching;
        if (pictureURI == null) {
            return;
        }
        boolean bl = prefetching = imageView == null;
        if (prefetching || !pictureURI.equals(imageView.getTag())) {
            if (!prefetching) {
                imageView.setTag((Object)profileId);
                imageView.setImageResource(this.getDefaultPicture());
            }
            ImageRequest.Builder builder = new ImageRequest.Builder(this.context.getApplicationContext(), pictureURI).setCallerTag((Object)this).setCallback(new ImageRequest.Callback(){

                @Override
                public void onCompleted(ImageResponse response) {
                    GraphObjectAdapter.this.processImageResponse(response, profileId, imageView);
                }
            });
            ImageRequest newRequest = builder.build();
            this.pendingRequests.put(profileId, newRequest);
            ImageDownloader.downloadAsync(newRequest);
        }
    }

    private void callOnErrorListener(Exception exception) {
        if (this.onErrorListener != null) {
            if (!(exception instanceof FacebookException)) {
                exception = new FacebookException(exception);
            }
            this.onErrorListener.onError(this, (FacebookException)exception);
        }
    }

    private void processImageResponse(ImageResponse response, String graphObjectId, ImageView imageView) {
        this.pendingRequests.remove(graphObjectId);
        if (response.getError() != null) {
            this.callOnErrorListener(response.getError());
        }
        if (imageView == null) {
            if (response.getBitmap() != null) {
                if (this.prefetchedPictureCache.size() >= 20) {
                    String oldestId = this.prefetchedProfilePictureIds.remove(0);
                    this.prefetchedPictureCache.remove(oldestId);
                }
                this.prefetchedPictureCache.put(graphObjectId, response);
            }
        } else if (graphObjectId.equals(imageView.getTag())) {
            Exception error = response.getError();
            Bitmap bitmap = response.getBitmap();
            if (error == null && bitmap != null) {
                imageView.setImageBitmap(bitmap);
                imageView.setTag((Object)response.getRequest().getImageUri());
            }
        }
    }

    private static int compareGraphObjects(GraphObject a, GraphObject b, Collection<String> sortFields, Collator collator) {
        for (String sortField : sortFields) {
            String sa = (String)a.getProperty(sortField);
            String sb = (String)b.getProperty(sortField);
            if (sa != null && sb != null) {
                int result = collator.compare(sa, sb);
                if (result == 0) continue;
                return result;
            }
            if (sa == null && sb == null) continue;
            return sa == null ? -1 : 1;
        }
        return 0;
    }

    public static interface DataNeededListener {
        public void onDataNeeded();
    }

    static interface Filter<T> {
        public boolean includeItem(T var1);
    }

    private static interface ItemPicture
    extends GraphObject {
        public ItemPictureData getData();
    }

    private static interface ItemPictureData
    extends GraphObject {
        public String getUrl();
    }

    public static interface OnErrorListener {
        public void onError(GraphObjectAdapter<?> var1, FacebookException var2);
    }

    public static class SectionAndItem<T extends GraphObject> {
        public String sectionKey;
        public T graphObject;

        public SectionAndItem(String sectionKey, T graphObject) {
            this.sectionKey = sectionKey;
            this.graphObject = graphObject;
        }

        public Type getType() {
            if (this.sectionKey == null) {
                return Type.ACTIVITY_CIRCLE;
            }
            if (this.graphObject == null) {
                return Type.SECTION_HEADER;
            }
            return Type.GRAPH_OBJECT;
        }

        public static enum Type {
            GRAPH_OBJECT,
            SECTION_HEADER,
            ACTIVITY_CIRCLE;

        }
    }
}

