/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.content.Context;
import android.location.Location;
import android.text.TextUtils;
import com.google.ads.doubleclick.DfpExtras;
import com.google.ads.mediation.NetworkExtras;
import com.google.ads.mediation.admob.AdMobAdapterExtras;
import com.google.ads.util.AdUtil;
import com.google.ads.util.b;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdRequest {
    public static final String VERSION = "6.3.1";
    private static final SimpleDateFormat a = new SimpleDateFormat("yyyyMMdd");
    private static Method b = null;
    private static Method c = null;
    private Gender d = null;
    private Date e = null;
    private Set<String> f = null;
    private Map<String, Object> g = null;
    private final Map<Class<?>, NetworkExtras> h = new HashMap();
    private Location i = null;
    private boolean j = false;
    private boolean k = false;
    public static final String LOGTAG = "Ads";
    public static final String TEST_EMULATOR;
    private Set<String> l = null;

    public AdRequest setGender(Gender gender) {
        this.d = gender;
        return this;
    }

    public Gender getGender() {
        return this.d;
    }

    @Deprecated
    public AdRequest setBirthday(String birthday) {
        if (birthday == "" || birthday == null) {
            this.e = null;
        } else {
            try {
                this.e = a.parse(birthday);
            }
            catch (ParseException parseException) {
                com.google.ads.util.b.e("Birthday format invalid.  Expected 'YYYYMMDD' where 'YYYY' is a 4 digit year, 'MM' is a two digit month, and 'DD' is a two digit day.  Birthday value ignored");
                this.e = null;
            }
        }
        return this;
    }

    public AdRequest setBirthday(Date birthday) {
        this.e = birthday == null ? null : new Date(birthday.getTime());
        return this;
    }

    public AdRequest setBirthday(Calendar calendar) {
        if (calendar == null) {
            this.e = null;
        } else {
            this.setBirthday(calendar.getTime());
        }
        return this;
    }

    public Date getBirthday() {
        return this.e;
    }

    public AdRequest clearBirthday() {
        this.e = null;
        return this;
    }

    @Deprecated
    public AdRequest setPlusOneOptOut(boolean plusOneOptOut) {
        this.a().setPlusOneOptOut(plusOneOptOut);
        return this;
    }

    @Deprecated
    public boolean getPlusOneOptOut() {
        return this.a().getPlusOneOptOut();
    }

    public AdRequest setKeywords(Set<String> keywords) {
        this.f = keywords;
        return this;
    }

    public AdRequest addKeyword(String keyword) {
        if (this.f == null) {
            this.f = new HashSet<String>();
        }
        this.f.add(keyword);
        return this;
    }

    public AdRequest addKeywords(Set<String> keywords) {
        if (this.f == null) {
            this.f = new HashSet<String>();
        }
        this.f.addAll(keywords);
        return this;
    }

    public Set<String> getKeywords() {
        if (this.f == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.f);
    }

    private synchronized AdMobAdapterExtras a() {
        if (this.getNetworkExtras(AdMobAdapterExtras.class) == null) {
            this.setNetworkExtras(new AdMobAdapterExtras());
        }
        return this.getNetworkExtras(AdMobAdapterExtras.class);
    }

    @Deprecated
    public AdRequest setExtras(Map<String, Object> extras) {
        this.a().setExtras(extras);
        return this;
    }

    @Deprecated
    public AdRequest addExtra(String key, Object value) {
        AdMobAdapterExtras adMobAdapterExtras = this.a();
        if (adMobAdapterExtras.getExtras() == null) {
            adMobAdapterExtras.setExtras(new HashMap<String, Object>());
        }
        adMobAdapterExtras.getExtras().put(key, value);
        return this;
    }

    public AdRequest setNetworkExtras(NetworkExtras extras) {
        if (extras != null) {
            this.h.put(extras.getClass(), extras);
        }
        return this;
    }

    public AdRequest removeNetworkExtras(Class<?> extrasClass) {
        this.h.remove(extrasClass);
        return this;
    }

    public <T> T getNetworkExtras(Class<T> extrasClass) {
        return (T)this.h.get(extrasClass);
    }

    public AdRequest setMediationExtras(Map<String, Object> mediationExtras) {
        this.g = mediationExtras;
        return this;
    }

    public AdRequest addMediationExtra(String key, Object value) {
        if (this.g == null) {
            this.g = new HashMap<String, Object>();
        }
        this.g.put(key, value);
        return this;
    }

    public AdRequest setLocation(Location location) {
        this.i = location;
        return this;
    }

    public Location getLocation() {
        return this.i;
    }

    @Deprecated
    public AdRequest setTesting(boolean testing) {
        this.j = testing;
        return this;
    }

    public Map<String, Object> getRequestMap(Context context) {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.f != null) {
            hashMap.put("kw", this.f);
        }
        if (this.d != null) {
            hashMap.put("cust_gender", this.d.ordinal());
        }
        if (this.e != null) {
            hashMap.put("cust_age", a.format(this.e));
        }
        if (this.i != null) {
            hashMap.put("uule", AdUtil.a(this.i));
        }
        if (this.j) {
            hashMap.put("testing", 1);
        }
        if (this.isTestDevice(context)) {
            hashMap.put("adtest", "on");
        } else if (!this.k) {
            object2 = null;
            object2 = AdUtil.c() ? "AdRequest.TEST_EMULATOR" : "\"" + AdUtil.a(context) + "\"";
            com.google.ads.util.b.c("To get test ads on this device, call adRequest.addTestDevice(" + (String)object2 + ");");
            this.k = true;
        }
        object2 = this.getNetworkExtras(AdMobAdapterExtras.class);
        DfpExtras dfpExtras = this.getNetworkExtras(DfpExtras.class);
        if (dfpExtras != null && dfpExtras.getExtras() != null && !dfpExtras.getExtras().isEmpty()) {
            hashMap.put("extras", dfpExtras.getExtras());
        } else if (object2 != null && ((AdMobAdapterExtras)object2).getExtras() != null && !((AdMobAdapterExtras)object2).getExtras().isEmpty()) {
            hashMap.put("extras", ((AdMobAdapterExtras)object2).getExtras());
        }
        if (dfpExtras != null && !TextUtils.isEmpty((CharSequence)(object = dfpExtras.getPublisherProvidedId()))) {
            hashMap.put("ppid", object);
        }
        if (this.g != null) {
            hashMap.put("mediation_extras", this.g);
        }
        try {
            Object object3;
            Map map;
            if (b != null && (map = (Map)(object3 = c.invoke(object = b.invoke(null, new Object[0]), new Object[0]))) != null && map.size() > 0) {
                hashMap.put("analytics_join_id", map);
            }
        }
        catch (Throwable throwable) {
            com.google.ads.util.b.c("Internal Analytics Error:", throwable);
        }
        return hashMap;
    }

    public AdRequest addTestDevice(String testDevice) {
        if (this.l == null) {
            this.l = new HashSet<String>();
        }
        this.l.add(testDevice);
        return this;
    }

    public AdRequest setTestDevices(Set<String> testDevices) {
        this.l = testDevices;
        return this;
    }

    public boolean isTestDevice(Context context) {
        if (this.l != null) {
            String string = AdUtil.a(context);
            if (string == null) {
                return false;
            }
            if (this.l.contains(string)) {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.google.analytics.tracking.android.AdMobInfo");
            for (Method method : clazz.getMethods()) {
                if (method.getName().equals("getInstance") && method.getParameterTypes().length == 0) {
                    b = method;
                    continue;
                }
                if (!method.getName().equals("getJoinIds") || method.getParameterTypes().length != 0) continue;
                c = method;
            }
            if (b == null || c == null) {
                b = null;
                c = null;
                com.google.ads.util.b.e("No Google Analytics: Library Incompatible.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.google.ads.util.b.a("No Google Analytics: Library Not Found.");
        }
        catch (Throwable throwable) {
            com.google.ads.util.b.a("No Google Analytics: Error Loading Library");
        }
        TEST_EMULATOR = AdUtil.b("emulator");
    }

    public static enum Gender {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    public static enum ErrorCode {
        INVALID_REQUEST("Invalid Ad request."),
        NO_FILL("Ad request successful, but no ad returned due to lack of ad inventory."),
        NETWORK_ERROR("A network error occurred."),
        INTERNAL_ERROR("There was an internal error.");

        private final String a;

        private ErrorCode(String description) {
            this.a = description;
        }

        public String toString() {
            return this.a;
        }
    }
}

