/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.Session;
import com.facebook.SessionState;

public class SessionTracker {
    private Session session;
    private final Session.StatusCallback callback;
    private final BroadcastReceiver receiver;
    private final LocalBroadcastManager broadcastManager;
    private boolean isTracking = false;

    public SessionTracker(Context context, Session.StatusCallback callback) {
        this(context, callback, null);
    }

    SessionTracker(Context context, Session.StatusCallback callback, Session session) {
        this(context, callback, session, true);
    }

    public SessionTracker(Context context, Session.StatusCallback callback, Session session, boolean startTracking) {
        this.callback = new CallbackWrapper(callback);
        this.session = session;
        this.receiver = new ActiveSessionBroadcastReceiver();
        this.broadcastManager = LocalBroadcastManager.getInstance((Context)context);
        if (startTracking) {
            this.startTracking();
        }
    }

    public Session getSession() {
        return this.session == null ? Session.getActiveSession() : this.session;
    }

    public Session getOpenSession() {
        Session openSession = this.getSession();
        if (openSession != null && openSession.isOpened()) {
            return openSession;
        }
        return null;
    }

    public void setSession(Session newSession) {
        if (newSession == null) {
            if (this.session != null) {
                this.session.removeCallback(this.callback);
                this.session = null;
                this.addBroadcastReceiver();
                if (this.getSession() != null) {
                    this.getSession().addCallback(this.callback);
                }
            }
        } else {
            if (this.session == null) {
                Session activeSession = Session.getActiveSession();
                if (activeSession != null) {
                    activeSession.removeCallback(this.callback);
                }
                this.broadcastManager.unregisterReceiver(this.receiver);
            } else {
                this.session.removeCallback(this.callback);
            }
            this.session = newSession;
            this.session.addCallback(this.callback);
        }
    }

    public void startTracking() {
        if (this.isTracking) {
            return;
        }
        if (this.session == null) {
            this.addBroadcastReceiver();
        }
        if (this.getSession() != null) {
            this.getSession().addCallback(this.callback);
        }
        this.isTracking = true;
    }

    public void stopTracking() {
        if (!this.isTracking) {
            return;
        }
        Session session = this.getSession();
        if (session != null) {
            session.removeCallback(this.callback);
        }
        this.broadcastManager.unregisterReceiver(this.receiver);
        this.isTracking = false;
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    public boolean isTrackingActiveSession() {
        return this.session == null;
    }

    private void addBroadcastReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_SET");
        filter.addAction("com.facebook.sdk.ACTIVE_SESSION_UNSET");
        this.broadcastManager.registerReceiver(this.receiver, filter);
    }

    private class ActiveSessionBroadcastReceiver
    extends BroadcastReceiver {
        private ActiveSessionBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Session session;
            if ("com.facebook.sdk.ACTIVE_SESSION_SET".equals(intent.getAction()) && (session = Session.getActiveSession()) != null) {
                session.addCallback(SessionTracker.this.callback);
            }
        }
    }

    private class CallbackWrapper
    implements Session.StatusCallback {
        private final Session.StatusCallback wrapped;

        public CallbackWrapper(Session.StatusCallback wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void call(Session session, SessionState state, Exception exception) {
            if (this.wrapped != null && SessionTracker.this.isTracking()) {
                this.wrapped.call(session, state, exception);
            }
            if (session == SessionTracker.this.session && state.isClosed()) {
                SessionTracker.this.setSession(null);
            }
        }
    }
}

