/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdClientEvent {
    private String name;
    private Map<String, Object> data;
    private int time;

    public AdClientEvent(String name, Map<String, Object> data, int time) {
        this.name = name;
        this.data = data;
        this.time = time;
    }

    public JSONObject getClientEventJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("data", (Object)new JSONObject(this.data));
            jsonObject.put("time", this.time);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public static AdClientEvent newErrorEvent(Exception ex) {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("ex", ex.getClass().getSimpleName());
        eventData.put("ex_msg", ex.getMessage());
        int eventTime = (int)(System.currentTimeMillis() / 1000L);
        return new AdClientEvent("error", eventData, eventTime);
    }
}

