/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Intent;
import android.os.Bundle;
import com.facebook.ads.internal.AdDataModel;
import com.facebook.ads.internal.AdInvalidationBehavior;
import com.facebook.ads.internal.AdInvalidationUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAdDataModel
implements AdDataModel {
    private static final String MARKUP_KEY = "markup";
    private static final String SECONDARY_MARKUP_KEY = "secondary_markup";
    private static final String ACTIVATION_COMMAND_KEY = "activation_command";
    private static final String SECONDARY_ACTIVATION_COMMAND_KEY = "secondary_activation_command";
    private static final String INVALIDATION_BEHAVIOR_KEY = "invalidation_behavior";
    private static final String DETECTION_STRINGS_KEY = "detection_strings";
    private final String markup;
    private final String secondaryMarkup;
    private final String activationCommand;
    private final String secondaryActivationCommand;
    private final AdInvalidationBehavior invalidationBehavior;
    private final Collection<String> detectionStrings;

    private HtmlAdDataModel(String markup, String secondaryMarkup, String activationCommand, String secondaryActivationCommand, AdInvalidationBehavior invalidationBehavior, Collection<String> detectionStrings) {
        this.markup = markup;
        this.secondaryMarkup = secondaryMarkup;
        this.activationCommand = activationCommand;
        this.secondaryActivationCommand = secondaryActivationCommand;
        this.invalidationBehavior = invalidationBehavior;
        this.detectionStrings = detectionStrings;
    }

    public String getMarkup() {
        return this.markup;
    }

    public String getActivationCommand() {
        return this.activationCommand;
    }

    public String getSendImpressionCommand() {
        return "facebookAd.sendImpression();";
    }

    @Override
    public AdInvalidationBehavior getInvalidationBehavior() {
        return this.invalidationBehavior;
    }

    @Override
    public Collection<String> getDetectionStrings() {
        return this.detectionStrings;
    }

    public Bundle saveToBundle() {
        Bundle instanceState = new Bundle();
        instanceState.putString(MARKUP_KEY, this.markup);
        return instanceState;
    }

    public void addToIntentExtra(Intent intent) {
        intent.putExtra(MARKUP_KEY, this.markup);
        intent.putExtra(ACTIVATION_COMMAND_KEY, this.activationCommand);
    }

    public void addSecondaryToIntentExtra(Intent intent) {
        intent.putExtra(SECONDARY_MARKUP_KEY, this.secondaryMarkup);
        intent.putExtra(SECONDARY_ACTIVATION_COMMAND_KEY, this.secondaryActivationCommand);
    }

    public Map<String, String> getDataModelMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MARKUP_KEY, this.secondaryMarkup);
        map.put(ACTIVATION_COMMAND_KEY, this.secondaryActivationCommand);
        return map;
    }

    public static HtmlAdDataModel fromBundle(Bundle instanceState) {
        String markup = instanceState.getString(MARKUP_KEY);
        String activationCommand = instanceState.getString(ACTIVATION_COMMAND_KEY);
        return new HtmlAdDataModel(markup, null, activationCommand, null, AdInvalidationBehavior.NONE, null);
    }

    public static HtmlAdDataModel fromIntentExtra(Intent intent) {
        String markup = intent.getStringExtra(MARKUP_KEY);
        String activationCommand = intent.getStringExtra(ACTIVATION_COMMAND_KEY);
        return new HtmlAdDataModel(markup, null, activationCommand, null, AdInvalidationBehavior.NONE, null);
    }

    public static HtmlAdDataModel fromJSONObject(JSONObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        String markup = dataObject.optString(MARKUP_KEY);
        String secondaryMarkup = dataObject.optString(SECONDARY_MARKUP_KEY);
        String activationCommand = dataObject.optString(ACTIVATION_COMMAND_KEY);
        String secondaryActivationCommand = dataObject.optString(SECONDARY_ACTIVATION_COMMAND_KEY);
        AdInvalidationBehavior invalidationBehavior = AdInvalidationBehavior.fromString(dataObject.optString(INVALIDATION_BEHAVIOR_KEY));
        JSONArray detectionStringsArray = null;
        try {
            detectionStringsArray = new JSONArray(dataObject.optString(DETECTION_STRINGS_KEY));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Collection<String> detectionStrings = AdInvalidationUtils.parseDetectionStrings(detectionStringsArray);
        return new HtmlAdDataModel(markup, secondaryMarkup, activationCommand, secondaryActivationCommand, invalidationBehavior, detectionStrings);
    }
}

