/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.TargetApi;
import android.net.http.SslCertificate;
import java.security.cert.X509Certificate;

@TargetApi(value=8)
public class SslError {
    public static final int SSL_NOTYETVALID = 0;
    public static final int SSL_EXPIRED = 1;
    public static final int SSL_IDMISMATCH = 2;
    public static final int SSL_UNTRUSTED = 3;
    public static final int SSL_MAX_ERROR = 4;
    int a;
    SslCertificate b;

    public SslError(int error, SslCertificate certificate) {
        this.addError(error);
        this.b = certificate;
    }

    public SslError(int error, X509Certificate certificate) {
        this.addError(error);
        this.b = new SslCertificate(certificate);
    }

    public SslCertificate getCertificate() {
        return this.b;
    }

    public boolean addError(int error) {
        boolean rval;
        boolean bl = rval = 0 <= error && error < 4;
        if (rval) {
            this.a |= 1 << error;
        }
        return rval;
    }

    public boolean hasError(int error) {
        boolean rval;
        boolean bl = rval = 0 <= error && error < 4;
        if (rval) {
            rval = (this.a & 1 << error) != 0;
        }
        return rval;
    }

    public int getPrimaryError() {
        if (this.a != 0) {
            for (int error = 3; error >= 0; --error) {
                if ((this.a & 1 << error) == 0) continue;
                return error;
            }
        }
        return 0;
    }

    public String toString() {
        return "primary error: " + this.getPrimaryError() + " certificate: " + this.getCertificate();
    }
}

